/*xxx
* \brief - SIM::cofdm_sel - carriers selector
* \author maki
*/

#ifndef COFDM_SEL_HPP
#define COFDM_SEL_HPP

#include <complex>
#include <itpp/itbase.h>
#include <itpp/itcomm.h>
#include "sim\_sim_extension.hpp"

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief COFDM carriers selector \n
 * Core immediate functions SIM::cofdm_sel.set_carriers() SIM::cofdm_sel.get_selected_carriers() \n
 * Core clocked functions SIM::cofdm_sel.process() \n
 */
class cofdm_sel
{
private:
  cvec carriers;        //!< local copy of COFDM symbol set by set_symbol()
  int	 NFFT;			      //!< NFFT=2^k - Nfft
  ivec sel_carriers;    //!< index of selected carriers

public:
  cvec y0;		          //!< y0[i] - QAM/PILOTS/ZERRO carriers selected  

  cofdm_sel()
  {
    NFFT = 256;
    carriers.set_size(NFFT);
    carriers.set_size(NFFT);
  };
  
  ~cofdm_sel() 
  { 
  };

  /*! set FFT size (2^k)
  \param [in] n - FFT size
  */
  void set_NFFT(int n);

  /*! selected data carrier indexes
  \param [in] c_indx - [ivec] data carrier indexes, 0 =< index < NFFT
  */
  void set_carriers_selector(ivec c_indx);
  
  /*! set QAM data carriers [I+jQ], pilots [+/-PA+j0], zero [0+j0] set by set_data() and set_pilots().
  \param [in] c [cvec] QAM,BPSK (data, pilots) carriers
  */
  void set_carriers(cvec c);
  
  // 
  /*! get subset of carriers  y[i] = [carriers[sel_carriers(i)]] 
  \return [cvec] subset of QAM,BPSK (data, pilots) carriers
  */
  cvec get_selected_carriers();

  /*! for active clock ticks ce[i] and for x[i,:][cvec] COFDM carriers return selected subset.
  \param ce - [bvec][:] - clock_enable vector,
  \param x -  [cmat][:,NFFT] carriers - QAM for data, BPSK for pilots,
  \return y - [cmat] - selected carriers.
  */
  cmat process(const bvec &ce, const cmat &x);

};


}
#endif //SIM_cofdm_mod
