/*xxx
* \brief - modulo N up counter with clock enable signal
* \author maki
*/



#ifndef SIM_COUNTER_HPP
#define SIM_COUNTER_HPP

#include <itpp/itbase.h>

using namespace itpp;
using namespace std;


namespace SIM
{

/*!
  * \brief binary modulo N up counter \n
  * Core function SIM::counter.generate() \n
  */
class counter
{
  int cnt;        //!< internal counter state
  int Nmod;       //!< Modulo number

public:
  counter()
  {
    cnt = 0;
    Nmod = 2;
  };

  ~counter()
  {
  };

  /*! set counter modulo value
  * \ modulo checked to be > 0
  * \param [in] N - [int] counter modulo number
  */
  void set_N(int N);

  /*! set internal counter state
  * \ state checked to be > 0 and < Nmod
  * \param [in] c - [int] counter state
  */
  void set_state(int c);

  /*! get counter modulo value
  * \return - [int] counter modulo number
  */
  int	get_N()
  {
    return (Nmod);
  };

  /*! get counter state value
  * \return - [int] counter state
  */
  int get_state()
  {
    return (cnt);
  };

  /*! reset counter state value
  */
  void reset()
  {
    cnt = 0;
  };

  /*! for active clock ticks [ce] increment state modulo N, carry is an output
  * \param ce - [bvec] - clock enable vector sizeof(ce)=N
  * \return y - [bvec] - state of carry flag
  */
  bvec generate(const bvec &ce);

};

} // SIM
#endif //SIM_counter
