/*xxx
* \brief - SIM::ejp - complex sine for normalized phase
* \author maki
*/


#ifndef SIM_EJP_HPP
#define SIM_EJP_HPP

#include <complex>

#include <itpp/itbase.h>
#include "sim\_sim_extension.hpp"


using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief normalized phase to complex [I,Q] sine converter \n
 * Core function: SIM::ejp.process() \n
 * \details ejp - exp(j*2pi*x) = cos(2pi*x)+jsin(2pi*x)
 */

class ejp
{
public:
  complexd y0;

  ejp()
  {
    y0 = complexd(1.0, 0.0);
  };
  
  ~ejp() 
  {
  };

  /*! set output value y0
   * \param [in] yout - [complex] => y0
   */
  void set_output(complexd yout);

  /*! get output
   * \return  -  [complex] y0
   */
  complexd get_output(void);

  /*! process input samples - [x] for active clock ticks [ce]
   * \param ce - [bvec] clock_enable vector
   * \param x  - [vec]  input vector - double fractional
   * \return y - [cvec] = [cos(2pi*x)+jsin(2pi*x)]
   */
  cvec process(const bvec &ce, const vec &x);
};

} // namespace SIM
#endif //SIM_EJP_HPP

