/*xxx
* \brief - SIM::fir - derived from SPUC::fir
* \author maki
*/

#ifndef SIM_FIR_HPP
#define SIM_FIR_HPP

#include "sim\spuc_fir.hpp"

using namespace itpp;
using namespace std;
using namespace SPUC;

/// SIM layer implements low level simulation models with \b itpp base classes as operational types.\n
namespace SIM
{
/*!
 * \brief FIR filter \n
 * Core function: SIM::fir.process() \n
 * \details
 * derived from SPUC::fir<double> with added ce interface \n
 * Inherited methods: \n
 * void set_taps(vec) \n
 * vec get_taps(void) \n
 * int get_size() \n
 */
class fir : public SPUC::fir < double >
{
public:
  double y0;      //!< registered filter output, initialized to 0.0 by constructor

  fir()
  {
    y0 = 0.0;
  } ;

  ~fir()
  {

  };

  /*! set internal state vector
  \param [in] v - [vec] state vector to set
  */
  void set_state(const vec &v);

  /*! set output value y0
  \param [in] yout - [double] => y0
  */
  void set_output(double yout);

  /*! get internal state vector
  \return  -  [vec] internal state vector
  */
  vec get_state(void);

  /*! get output
  \return  -  [double] y0
  */
  double get_output(void);

  /*! process input samples - [x] for active clock ticks [ce]
  * \param ce - bvec - clock enable vector
  * \param x -  vec  - input sample vector
  * \return y - vec  - output sample vector
  */
  vec process(const bvec &ce, const vec &x);

};

}	   // namespace SIM
#endif //SIM_FIR_HPP

