/*xxx
* \brief SIM::fir_up - FIR up-sampling filter
* \author maki
*/


#ifndef SIM_FIR_UP_HPP
#define SIM_FIR_UP_HPP

#include "sim\sim_fir.hpp"

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief up-sampling FIR filter \n
 * Core function SIM::fir_up.process() \n
 * \details
 * when cei[n] & ceo[n] are active (ceio = [cei|ceo] = [1 1]), input x is processed \n
 * when only ceo[n] is active (ceio = [cei|ceo] = [0 1]), zero input 0.0 is processed \n
 */
class fir_up : public SIM::fir
{
public:

  fir_up()
  {
  };
  ~fir_up()
  {
  };

  vec process(const bmat &ceio, const vec &x);
};

}	   // namespace SIM
#endif //SIM_FIR_UP_HPP

