/*!
* \brief SIM::fir_x_up complex up-sampling filter
* \author maki
*/

#ifndef SIM_FIR_UP_X_HPP
#define SIM_FIR_UP_X_HPP

#include "sim\sim_fir_x.hpp"

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
* \brief complex up-sampling FIR filter \n
* Core function SIM::fir_up_x.process() \n
* \details
* when cei[n] & ceo[n] are active (ce =[1 1]), complex input x is processed \n
* when only ceo[n] is active (ce =[0 1]), zero input (0.0+j0.0) is processed \n
*/
class fir_up_x : public SIM::fir_x
{
public:

  fir_up_x()
  {
  };

  ~fir_up_x()
  {
  };

  cvec process(const bmat &ce, const cvec &x);
};

}	   // namespace SIM
#endif //SIM_FIR_HPP

