/*xxx
* \brief SIM class for complex fir filter
* \author maki
*/



#ifndef SIM_FIR_X_HPP
#define SIM_FIR_X_HPP

#include "sim\_sim_extension.hpp"

#include "spuc_fir.hpp"

using namespace itpp;
using namespace std;
using namespace SPUC;


namespace SIM
{


/*!
 * \brief complex FIR filter\n
 * Core function: SIM::fir_x.process() \n
 * \details
 * derived from SPUC::fir<complex> with added ce interface \n
 * Inherited methods: \n
 * void set_taps(cvec) \n
 * cvec get_taps(void) \n
 * int get_size() \n
 */


class fir_x : public SPUC::fir < complexd >
{
public:
  complexd y0;  //!< filter output, initialized to (0.0+j0.0) by constructor

  fir_x()
  {
    y0 = (0.0, 0.0);
  };

  ~fir_x()
  {
  };

  /*! set internal state vector
  \param [in] cv - [cvec] state vector to set
  */
  void set_state(const cvec &cv);

  /*! set output value y0
  \param [in] yout - [complex] => y0
  */
  void set_output(complexd yout);

  /*! get internal state vector
  \return  -  [cvec] internal state vector
  */
  cvec get_state(void);

  /*! get output
  \return  -  [complex] y0
  */
  complexd get_output(void);

  /*! process input samples - [x] for active clock ticks [ce]
  * \param ce - bvec - clock enable vector
  * \param x -  cvec  - complex input sample vector
  * \return y - cvec  - complex output sample vector
  */
  cvec process(const bvec &ce, const cvec &x);
};

}
#endif //SIM_FIR_X

