/*xxx
* \brief - SIM::int2bin - SIM layer implementation of integer to binary converter
* \author maki
*/

#ifndef SIM_INT2BIN_HPP
#define SIM_INT2BIN_HPP

#include <itpp/itbase.h>

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief binary to integer converter \n
 * Core function SIM::int2bin.process() \n
 */
class int2bin
{
private:
  bool msb_first;		//!< x[0]=MSB - default
  int symbol_size;	//!< bits per ce - clock tick
  bvec y0;			    //!< y0 - output for ce=0

public:

  int2bin()
  {
    msb_first = true;
  };

  ~int2bin()
  {
  };

  /*! set size of a symbol - W - number of columns for binary symbol
  \param [in] W - [int] size of a symbol
  */
  void set_symbol_size(int W);

  /*! set msb flag - x[0]=MSB
  \param [in] msb - [bool] flag
  */
  void set_msb_flag(bool msb);

  /*! sets initial/idle output symbol
  \param [in] yout - [bvec] y0 = yout
  */
  void set_output(const bvec &yout);

  /*! get size of a symbol - number of columns for binary symbol
  \return [int] size of a symbol W
  */
  int get_symbol_size();

  /*! get msb flag - x[0]=MSB
  \return   - [bool] msb flag - x[0]=MSB
  */
  bool get_msb_flag();

  /*! get initial/idle output symbol
  \return  - [bvec] y0
  */
  bvec get_output();

  /*! for active clock ticks ce[i] convert one input symbol x[i] into binary symbol y[i,W]
  \param  ce - [bvec] - clock enable vector - sizeof(ce)=N
  \param  x -  [ivec] - input symbols vector - sizeof(x)=N
  \return y -  [bmat] - output symbols matrix - sizeof(y)=[N,W]
  */
  bmat process(const bvec &ce, const ivec &x);

};

}
#endif //SIM
