/*xxx
* \brief - SIM::iq2ap -  IQ to amplitude/phase
* \author maki
*/


#ifndef SIM_IQ2AP_HPP
#define SIM_IQ2AP_HPP

#include <complex>

#include <itpp/itbase.h>

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief I,Q to amplitude,phase converter \n
 * Core function SIM::iq2ap.process() \n
 * \details 
 * iq2ap -  [I,Q]->A*exp(j*ph)
 */

class iq2ap
{
  vec y0;   

public:

  iq2ap()
  {
    y0.set_length(2);
    y0(0) = 0.0;
    y0(1) = 0.0;
  };
  
  ~iq2ap() 
  {
  };

  /*! set output value y0
  * \param [in] yout - [vec] y0 
  */
  void set_output(vec yout);

  /*! get output value y0
  * \return - [vec] y0
  */
  vec get_output(void);

  /*! process input samples - [x] for active clock ticks [ce]
  * \param [in] ce [bvec] clock_enable vector
  * \param [in] x  [cvec] input vector [I+jQ] 
  * \return     y  [mat] output vector y = [A,ph]
  */
  mat process(const bvec &ce, const cvec &x);
};

}	   // namespace SIM
#endif //SIM_IQ2AP_HPP

