/*xxx
* \brief - SIM::mix - multipling two input mixer
* \author maki
*/


#ifndef SIM_MIX_HPP
#define SIM_MIX_HPP

#include <itpp/itbase.h>

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief two input mixer \n
 * Core function: SIM::mix.process() \n
 */
class mix
{
public:
  double y0;

  mix()
  {
    y0 = 0.0;
  };
  
  ~mix() 
  {
  };

  /*! set output state y0
  * \param [in] yout - [double] => y0
  */
  void set_output(double yout);

  /*! get output state y0
  * \return - [double] y0
  */
  double get_output(void);

  /*! process input samples - [x] for active clock ticks [ce]
   * \param ce [bvec] clock_enable vector
   * \param  x [mat] [x1|x2] - input matrix
   * \return y [vec] y = (x1*x2)
   */
  vec process(const bvec &ce, const mat &x);
};

}	   // namespace SIM
#endif //SIM_MIX_HPP

