/*!
* \brief - SIM::mix_x - two input multipling complex mixer
* \author maki
*/


#ifndef SIM_MIX_X_HPP
#define SIM_MIX_X_HPP

#include <complex>

#include <itpp/itbase.h>
#include "sim\_sim_extension.hpp"

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief complex mixer \n
 * Core function: SIM::mix_x.process() \n
 */
class mix_x
{
public:
  complexd y0;

  mix_x()
  {
    y0 = complexd(0.0, 0.0);
  };

  ~mix_x() 
  {
  };

  /*! set output state y0
  * \param [in] yout - [complex] => y0
  */
  void set_output(complexd yout);

  /*! get output state y0
  * \return - [double] y0
  */
  complexd get_output(void);


  /*! process input samples - [x] for active clock ticks [ce]
  * \param ce [bvec] clock_enable vector
  * \param  x [cmat] [x1|x2] - input matrix
  * \return y [cvec] y = (x1*x2)
  */
  cvec process(const bvec &ce, const cmat &x);
};

}	   // namespace SIM
#endif //SIM_MIX_HPP

