/*xxx
* \brief - SIM::pam_dem - PAM demodulator - derived from itpp::PAM
* \author maki
*/

#ifndef SIM_PAM_DEM_HPP
#define SIM_PAM_DEM_HPP

#include <itpp/itbase.h>
#include <itpp/itcomm.h>

#include <complex>

using namespace itpp;
using namespace std;


namespace SIM
{

/*!
 * \brief PAM demodulator \n
 * Core function: SIM::pam_mod.process() \n
 */
class pam_dem : public itpp::PAM
{
private:
  int y0;			    //!< y0 - output for ce=0
  int	 M;			    //!< M=2^k - constellation size
  double scale;   //!< scale factor - default set by set_size()
public:
  pam_dem()  
  { 
  };
  
  ~pam_dem() 
  { 
  };

  /*! set constellation size M=2,4,8,16,...
  \param [in] m - constellation size
  */
  void set_size(int m);

  /*! set scale - default scaling is set by set_size() for [-1..+1] range
  \param [in] s - scale
  */
  void set_scale(double s);

  /*! set output value y0
  \param [in] yout => y0
  */
  void set_output(int yout);

  /*! get M - constellation size
  \return  - constellation size
  */
  int get_size();

  /*! get scale
  \return  - scale factor
  */
  double get_scale();

  /*! get output
  \return  -  [double] y0
  */
  int get_output();

  /*! for active clock ticks ce[i] and  for given PAM symbol x[i] return symbol code y[i]
  \param ce - bvec - clock_enable vector
  \param x -  vec - symbol vector
  \return y - ivec - symbol code ;
  */
  ivec process(const bvec &ce, const vec &x);

};


}
#endif //SIM_pam_dem
