/*!
* \brief - SIM::pam_mod - PAM modulator derived from itpp::PAM
* \author maki
*/

#ifndef SIM_PAM_MOD_HPP
#define SIM_PAM_MOD_HPP

#include <itpp/itbase.h>
#include <itpp/itcomm.h>
#include "sim\_sim_extension.hpp"

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief PAM modulator \n
 * Core function: SIM::pam_mod.process() \n
 */
class pam_mod : public itpp::PAM
{
private:
  double y0;			  //!< y0 - output for ce=0
  int	 M;				    //!< M=2^k - constellation size
  double scale;     //!< scale factor - default set by set_size() 

public:
  pam_mod()  
  { 
  };

  ~pam_mod() 
  { 
  };

  /*! set constellation size M=2,4,8,16,...
  \param [in] m - constellation size
  */
  void set_size(int m);

  /*! set scale - default scaling is set by set_size() for [-1..+1] range
  \param [in] s - scale
  */
  void set_scale(double s);

  /*! set output value y0
  \param [in] yout => y0
  */
  void set_output(double yout);

  /*! get M - constellation size 
  \return  - constellation size
  */
  int get_size();
  
  /*! get scale
  \return  - scale factor
  */
  double get_scale();
  
  /*! get output
  \return  -  [double] y0
  */
  double get_output();

  /*! for active clock ticks ce[i] and  for given symbol code x[i] return PAM symbol y[i]
  \param ce - bvec - clock_enable vector
  \param x - ivec - symbol code vector
  \return y - vec - symbol vector normalized [-1..+1];
  */
  vec process(const bvec &ce, const ivec &x);

};


}
#endif //SIM_pam_mod
