/*xxx
* \brief - SIM::psk_dem - derived from itpp::PSK
* \author maki
*/

#ifndef SIM_PSK_DEM_HPP
#define SIM_PSK_DEM_HPP

#include <itpp/itbase.h>
#include <itpp/itcomm.h>

#include <complex>
#include "sim\_sim_extension.hpp"

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief PSK demodulator \n
 * Core function: SIM::psk_dem.process() \n
 */
class psk_dem : public itpp::PSK
{
private:
  int y0;			    //!< y0 - output for ce=0
  int	 M;			    //!< M=2^k - constellation size
  double scale;   //!< default scaling is IQ[-1..+1][-1..+1]

public:  
  psk_dem()  
  { 
    y0 = 0;
  };
  
  ~psk_dem() 
  { 
  };

  /*! set constellation size M=2,4,8,16,...
  \param [in] m - constellation size
  */
  void set_size(int m);
  
  /*! set scale - default scaling is set by set_size() for normalized IQ[-1..+1]
  \param [in] s - scale
  */
  void set_scale(double s);
  
  /*! set output value y0
  \param [in] yout - [int] => y0
  */
  void set_output(int yout);

  /*! get M - constellation size 2,4,8,16,...
  \return  - constellation size
  */
  int get_size();

  /*! get scale
  \return  - scale factor
  */
  double get_scale();

  /*! get output
  \return  -  [int] y0
  */
  int get_output();

  /*! for active clock ticks ce[i] return symbol code y[i] for a sliced complex input x[i]=I+j*Q
  \param ce - bvec - clock_enable vector
  \param x - cvec -  complex normalized symbol  I+jQ
  \return y -  ivec - symbol code vector ;
  */
  ivec process(const bvec &ce, const cvec &x);

};


}
#endif //SIM_psk_dem
