/*
* \brief - SIM::qam_dem - derived from itpp::QAM
* \author maki
*/

#ifndef SIM_QAM_DEM_HPP
#define SIM_QAM_DEM_HPP

#include <itpp/itbase.h>
#include <itpp/itcomm.h>

#include <complex>
#include "sim\_sim_extension.hpp"

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief QAM demodulator \n
 * Core function: SIM::qam_dem.process() \n
 */

class qam_dem : public itpp::QAM
{
private:
  int y0;			    //!< y0 - output for ce=0
  int	 M;				  //!< M=2^k - constellation size
  double scale;

public:
  qam_dem()
  {
    y0 = 0;
  };

  ~qam_dem()
  {
  };

  /*! set size - square constellation size M=4,16,64,256,...
    \param [in] m - constellation size
  */
  void set_size(int m);

  /*! set scaling - default scaling is IQ[-1..+1][-1..+1] and set by set_size()
  \param [in] s - scale
  */
  void set_scale(double s);

  /*! set output value y0
  \param [in] yout - [int] => y0
  */
  void set_output(int yout);

  /*! get M - square constellation size 4,16,64,256,...
  \return  - constellation size
  */
  int get_size();

  /*! get scale
  \return  - scale factor
  */
  double get_scale();

  /*! get output
  \return  -  [int] y0
  */
  int get_output();

  /*! for active clock ticks ce[i] return symbol code y[i] for a sliced complex input x[i]=I+j*Q\n
  \param ce - bvec - clock_enable vector
  \param x  - cvec - iq complex symbol - normalized [I,Q] = [(-1..+1),(-1..+1)]
  \return y - ivec - symbol code vector
  */
  ivec process(const bvec &ce, const cvec &x);

};


}
#endif //SIM_qam_dem
