/*xxx
* \brief - SIM::qam_mod - SIM layer implementation of QAM modulator
* \author maki
*/



#ifndef SIM_QAM_MOD_HPP
#define SIM_QAM_MOD_HPP

#include <itpp/itbase.h>
#include <itpp/itcomm.h>

#include <complex>
#include "sim\_sim_extension.hpp"


using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief QAM modulator \n
 * Core function: SIM::qam_mod.process() \n
 */
class qam_mod : public itpp::QAM
{
private:
  complexd y0;			//!< y0 - output for ce=0
  int	 M;						//!< M=2^k - constellation size
  double scale;

public:
  qam_mod()
  {
    y0 = complexd(0, 0); // this is very likely not valid, but better than trash
  };

  ~qam_mod()
  {
  };

  /*! set size - square constellation size M=4,16,64,256,...
  \param [in] m - constellation size
  */
  void set_size(int m);

  /*! set scaling - default scaling is IQ[-1..+1][-1..+1] and set by set_size()
  \param [in] s - scale
  */
  void set_scale(double s);

  /*! set output value y0
  \param [in] yout - [complex] => y0
  */
  void set_output(complexd yout);

  /*! get M - square constellation size 4,16,64,256,...
  \return  - constellation size
  */
  int get_size();

  /*! get scale
  \return  - scale factor
  */
  double get_scale();

  /*! get output
  \return  -  [double] y0
  */
  complexd get_output();

  /*! for active clock ticks ce[i] return complex symbol y[i]=I+j*Q for a given symbol code x[i]\n  
    \param ce - bvec - clock_enable vector
    \param x - ivec - symbol code vector
    \return y - cvec - iq complex symbol normalized iq = [-1..+1][-1..+1] ;
  */
  cvec process(const bvec &ce, const ivec &x);

};


}
#endif //SIM_qam_mod
