/*xxx
* \brief - SIM::rms - SIM layer implementation of RMS measuring block
* \author maki
*/



#ifndef SIM_RMS_HPP
#define SIM_RMS_HPP

#include <itpp/itbase.h>

#include "sim_fir.hpp"

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief RMS calculator for real-value signals \n
 * Core function: SIM::rms.process() \n
 * \details
 * y=sqrt(MAV< x^2 >)
 * where MAV is a moving avarage of N samples implemented as a FIR filter
 * mav< s > = (s[i]+s[i-1]+...s[i-N-1])/N
 */
class rms
{
private:
  double y0;				    //!< y0 - output for ce=0
  int N;                //!< size of MAV moving avarage filter
  SIM::fir fir_mav;			//!< MAV moving average filter

public:
  rms()
  {
    y0 = 0.0;
  };

  ~rms()
  {
  };

  /*! set size of a MAV filter
  \param [in] n - [int] size of MAV
  */
  void set_size(int n);

  /*! sets initial/idle output symbol
  \param [in] yout - [int] y0 = yout
  */
  void set_output(double yout);

  /*! get size of a MAV filter
  \return - [int] size of MAV
  */
  int get_size(void);

  /*! get initial/idle output symbol
  \return  - [int] y0
  */
  double get_output(void);

  /*! for active clock ticks ce[i] calculate RMS using moving avarage of squared input
  \param  ce - [bvec] - clock enable vector - sizeof(ce)=N
  \param  x -  [vec] - input  vector sizeof(x)=[N]
  \return y -  [vec] - output  vector - sizeof(y)=[N]
  */
  vec process(const bvec &ce, const vec &x);

};


}
#endif //SIM_rms
