/*xxx
* \brief - SIM::rms_x - complex signal RMS measuring block using moving average MAV fir
* \author maki
*/



#ifndef SIM_RMS_X_HPP
#define SIM_RMS_X_HPP

#include <itpp/itbase.h>
#include <complex>

#include "sim\_sim_extension.hpp"

#include "sim_fir.hpp"


using namespace itpp;
using namespace std;


namespace SIM
{

/*!
* \brief RMS calculator for complex signals \n
* Core function: SIM::rms_x.process() \n
*\details
* y=sqrt(MAV<real(x*conj(x))>)
* where MAV is a moving avarage of N samples implemented as a FIR filter
* mav< s > = (s[i]+s[i-1]+...s[i-N-1])/N
*/
class rms_x
{
private:
  double y0;				    //!< y0 - output for ce=0
  int N;                //!< size of MAV moving avarage filter
  SIM::fir fir_mav;			//!< MAV moving average filter

public:
  rms_x()
  {
    y0 = 0.0;
  };

  ~rms_x()
  {
  };

  /*! set size of a MAV filter
  \param [in] n - [int] size of MAV
  */
  void set_size(int n);

  /*! sets initial/idle output symbol
  \param [in] yout - [int] y0 = yout
  */
  void set_output(double yout);

  /*! get size of a MAV filter
  \return - [int] size of MAV
  */
  int get_size(void);

  /*! get initial/idle output symbol
  \return  - [int] y0
  */
  double get_output(void);

  /*! for active clock ticks ce[i] calculate RMS using moving avarage of squared input module
  \param  ce - [bvec] - clock enable vector - sizeof(ce)=N
  \param  x -  [cvec] - input  vector sizeof(x)=[N]
  \return y -  [vec] - output  vector - sizeof(y)=[N]
  */
  vec process(const bvec &ce, const cvec &x);

};


}
#endif //SIM_rms_x
