/*!
* \brief - SIM::src_x - complex sample rate converter with fir sinc reconstruction fir filter
* \author maki
*/

#ifndef SIM_SRC_X_HPP
#define SIM_SRC_X_HPP

#include <itpp/itbase.h>
#include "sim\_sim_extension.hpp"

#include "sim\sim_src.hpp"

using namespace itpp;
using namespace std;

namespace SIM
{
/*!
 * \brief complex sample rate converter with sinc reconstruction filter \n
 * Core function: SIM::src_x.process() \n
 */
class src_x
{
private:
  src src_i;        //!< I sample rate converter
  src src_q;        //!< Q sample rate converter
  complexd y0;      //!< I+jQ - registered filter output
public:

  /*! default complex SRC uses two I,Q fir filters with 15 taps sinc kernels and hanning windows
  */
  src_x()
  {
  };
  
  ~src_x()
  {
  };

  /*! set sinc kernel size
  \param [in] n  - [int] kernel size
  */
  void set_size(int n);
  
  /*! set window type
  \param [in] w  - [int] window type WIN_HANNING=1, WIN_KAISER_BESSEL=2, WIN_FLAT_TOP=3
  */
  void set_win_type(int w);
  
  /*! set output value y0
  \param [in] yout - [complex] => y0
  */
  void set_output(complexd yout);

  /*! get sinc kernel size
  \return  -  [int] sinc fir kernel size
  */
  int get_size(void);
  
  /*! get sinc window type
  \return  -  [int] sinc fir kernel window type WIN_HANNING=1, WIN_KAISER_BESSEL=2, WIN_FLAT_TOP=3
  */
  int get_win_type(void);
  
  /*! get output
  \return  -  [double] y0
  */
  complexd get_output(void);

  /*! process input complex samples xt[0,i]=I+jQ for active input clock ticks ce[0,i]\n
  for active output clock tick ce[1,i] reconstruct complex output y[i]=I+jQ for a given fractional time xt[1,i] \n
  * \param ceio - [bmat] - input/output [cei|ceo] clock enable matrix
  * \param xt -   [cmat] - input samples and fractional time xt=[x|t] matrix, time is real - common for both I,Q signals
  * \return y -   [cvec] - complex output samples vector
  */
  cvec process(const bmat &ceio, const cmat &xt);
};

}	   // namespace SIM
#endif //SIM_SRC_X_HPP

