/*xxx
* \brief - SIM::tedg_x  - dual timing error detector - gardner with mods
* \author maki
*/

#ifndef SIM_TEDG_X_HPP
#define SIM_TEDG_X_HPP

#include <itpp/itbase.h>
#include <complex>
#include "sim\_sim_extension.hpp"

#include "sim\_sim_enum_def.h"

using namespace itpp;
using namespace std;

namespace SIM
{
/*!
 * \brief dual timing error detector - gardner with mods \n
 * Core function: SIM::tedg_x.process() \n
 */
class tedg_x
{
private:
  complexd x0, x1, x2;      //!< x[k], x[k-1], x[k-2]
  complexd y0;              //!< output state
  tedg_mode op_mode;        //!< mode of operation
  double quantum;           //!< output quntum in pump mode
public:

  tedg_x()
  {
    x0 = complexd(0, 0);
    x1 = x0;
    x2 = x1;
    op_mode = TEDG_MODE_STD;
    quantum = 1.0;
  };

  ~tedg_x()
  {
  };

  /*! set detector mode 
  * \param [in] m - [int] mode - supported modes enum tedg_mode 
  */
  void set_mode(int m);

  /*! set quantum for pump value
  * \param [in] p - [double] pump
  */
  void set_quantum(double p);
  
  /*! set output state y0
  * \param [in] yout - [complex] => y0
  */
  void set_output(complexd yout);

  /*! get output state y0
  * \return - [double] y0
  */
  int get_mode(void);

  /*! get quantum for pump value   
  * \return - [double] pump
  */
  double get_quantum(void);
 
  /*! get output state y0
  * \return - [complex] y0
  */
  complexd get_output(void);

  /*! for active input clock ticks ceio[0,i] acquire input sample x[i] \n
      for active output clock ticks ceio[0,i] compute detector response y[i] according with selected mode 
  * \param ceio - [bmat] [cei | ceo] input clock enable, output clock enable
  * \param    x - [cvec] [xi +jxq]  quadrature input
  * \return   y - [cvec] [yi+jyq] cvec quadrature detector output
  */
  cvec process(const bmat &ceio, const cvec &x);
};

}// namespace SIM
#endif //SIM_TEDG_X_HPP

