/*xxx
* \brief vco - VCO is variable controlled oscillator a version of NCO with floating point accumulator ph=(-1.0..1.0)
* \author maki
*/

#ifndef SIM_VCO_HPP
#define SIM_VCO_HPP

#include <itpp/itbase.h>

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
* \brief floating point point NCO - numerically controlled oscillator \n
* Core function: SIM::vco.process() \n
* \details
* Accumulated phase ph is in double fractional format (-1.0..+1.0) \n
* input vector x [vec] is frequency control word - saturated at (-1..+1) \n
* vco output is a matrix mat=[cy|ph] where: \n
* cy is overflow flag: +1 for positive -1 for negative \n
* ph = acc - is accumulated phase in double fractional format \n
*/
class vco
{
  vec y0; // [cy,ph]
  double ph;

public:

  vco()
  {
    y0.set_length(2);
    y0(0) = 0.0;
    y0(1) = 0.0;
    ph = 0.0;
  };

  ~vco()
  {
  };

  /*! set state of phase accumulator
  \param [in] a - state of phase accumulator in double fractional format
  */
  void set_acc(double a);

  /*! set initial output value y0
  \param [in] yout - [vec] = [cy|ph]
  */
  void set_output(const vec &yout);

  /*! get state of phase accumulator */
  double get_acc();

  /*! get initial output value y0 */
  vec get_output(void);

  /*! process input samples - x[i] for active clock ticks ce[i]
  * \param ce - bvec - clock enable vector
  * \param x -  vec  - input vector - fcw saturated at (-1..+1) in double fractional format
  * \return y - mat  - output matrix [cy|ph] cy =(1,0,-1), ph - accumulated phase in double fractional format
  */
  mat process(const bvec &ce, const vec &x);
};

}	   // namespace SIM
#endif //SIM_VCO_HPP

