/*xxx
* \brief - SIM::wgn - SIM layer implementation of WGN source
* \author maki
*/

#ifndef SIM_WGN_HPP
#define SIM_WGN_HPP

#include <itpp/itbase.h>
#include <itpp/comm/sequence.h>

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
* \brief real value WGN generator source \n
* Core function: SIM::wgn.generate() \n
*/
class wgn
{
public:
  double y0;
  double sigma;
  double mean;

  wgn()
  {
    y0 = 0.0;
    mean = 0.0;
    sigma = 1.0;
  };

  ~wgn()
  {
  };

  /*! set AC- RMS of a WGN
  \param [in] s - [double] AC RMS
  */
  void set_sigma(double s);

  /*! set DC of a WGN
  \param [in] m - [double] DC
  */
  void set_mean(double m);

  /*! sets initial/idle output symbol
  \param [in] yout - [double] y0 = yout
  */
  void set_output(double yout);

  /*! get AC-RMS of a WGN
  \return - [double] AC-RMS
  */
  double get_sigma(void);

  /*! get DC of a WGN
  \return - [double] DC
  */
  double get_mean(void);

  /*! get initial/idle output symbol
  \return  - [double] y0
  */
  double get_output(void);

  /*! for active clock ticks ce[i] generate new sample of white noise
  \param  ce - [bvec] - clock enable vector - sizeof(ce)=N
  \return y -  [vec] - output  vector - sizeof(y)=[N]
  */
  vec generate(const bvec &ce);
};

}	   // namespace SIM
#endif //SIM_WGN_HPP

