/*xxx
* \brief - SIM::wgn_x - SIM layer implementation of complex WGN source
* \author maki
*/



#ifndef SIM_WGN_X_HPP
#define SIM_WGN_X_HPP

#include <complex>

#include <itpp/itbase.h>
#include <itpp/comm/sequence.h>

#include "sim\_sim_exception.hpp"
#include "sim\_sim_extension.hpp"


using namespace itpp;
using namespace std;

namespace SIM
{
/*!
* \brief complex value WGN generator source \n
* Core function: SIM::wgn_x.generate() \n
*/
class wgn_x
{
public:
  complexd y0;
  double sigma;
  complexd mean;
  static double normalize ;

  wgn_x()
  {
    y0 = complexd(0.0, 0.0);
    mean = complexd(0.0, 0.0);
    sigma = 1.0;
  };

  ~wgn_x()
  {
  };

  /*! set AC- RMS of a WGN
  \param [in] s - [double] AC RMS
  */
  void set_sigma(double s);

  /*! set complex DC of a WGN
  \param [in] m - [complex double] DC
  */
  void set_mean(complexd m);

  /*! sets initial/idle output symbol
  \param [in] yout - [complex double] y0 = yout
  */
  void set_output(complexd yout);

  /*! get AC-RMS of a WGN
  \return - [double] AC-RMS
  */
  double get_sigma(void);

  /*! get complex DC of a WGN
  \return - [complex double] DC
  */
  complexd get_mean(void);

  /*! get initial/idle output symbol
  \return  - [complex double] y0
  */
  complexd get_output(void);

  /*! for active clock ticks ce[i] generate new sample of complex white noise
  \param  ce - [bvec] - clock enable vector - sizeof(ce)=N
  \return y -  [cvec] - output vector - sizeof(y)=[N]
  */
  cvec generate(const bvec &ce);
};

}	   // namespace SIM
#endif //SIM_WGN_X_HPP

