/*xxx
* \brief test functions for SCI namespace
* \author maki
*/

#ifndef TF_SCI_HPP
#define TF_SCI_HPP

#ifdef SCI_TEST_ALL

#define SCI_TEST_FIR
#define SCI_TEST_FIR_X
#define SCI_TEST_LFSR
#define SCI_TEST_COUNTER
#define SCI_TEST_LSR
#define SCI_TEST_BERT
#define SCI_TEST_QAM
#define SCI_TEST_BIN2INT
#define SCI_TEST_RMS
#define SCI_TEST_WGN
#define SCI_TEST_FIR_UP
#define SCI_TEST_NCO
#define SCI_TEST_EJP
#define SCI_TEST_AMP_X
#define SCI_TEST_MIX_X
#define SCI_TEST_IQ2AP
#define SCI_TEST_CIRCBUFF_X
#define SCI_TEST_PSK
#define SCI_TEST_SRC_X
#define SCI_TEST_COFDM
#define SCI_TEST_PAM
#define SCI_TEST_CASDEC_X
#define SCI_TEST_BINBUFF
#define SCI_TEST_TEDG_X
#endif

//! Master function
int tf_sci();
//! Init FIR as MAV fir filter using vector - get impulse response
int tf_sci_fir();
//! Init FIR_X as complex MAV fir filter using vector - get impulse response
int tf_sci_fir_x();
//! Int LFSR as prbs(2^3-1=7) sequence, get 4 periods
int tf_sci_lfsr();
//! Init COUNTER as by 4 get output for 4*4 clocks
int tf_sci_counter();
//! Init LSR and use it as binary fifo for PRBS data generated by LFSR
int tf_sci_lsr();
//! Init BERT and lock it to PRBS data generated by LFSR
int tf_sci_bert();
//! Modulate and demodulate qam symbols
int tf_sci_qam();
//! Convert ivec [0..N-1] into bvec and back to ivec
int tf_sci_bin2int();
//! Find rms of ones(W) and complex_ones(W)
int tf_sci_rms();
//! Find rms of wgn(0,1) and complex wgn(0,1)
int tf_sci_wgn();
//! Init MAV fir filter for UP=8 real and complex response
int tf_sci_fir_up();
//! compare nco and vco outputs for given phase step
int tf_sci_nco();
//! for normalized phase from nco get exp(j*ph)
int tf_sci_ejp();
//! Modulate and demodulate qam symbols with conversion between
int tf_sci_iq2ap();
//! Mix exp(j*p) * exp(-jp)
int tf_sci_mix_x();
//! sample and hold nco output with amp and amp_x
int tf_sci_amp_x();
//! test process, put, peek, get for circullar buffer
int tf_sci_circbuff_x();
//! brief - sci_psk_mod, sci_psk_dem test application
int tf_sci_psk();
//! brief - get src_x impulse response
int tf_sci_src_x();
//! compare discrete and device response of casdec_x for wgn_x
int tf_sci_casdec_x();
//! Modulate and demodulate cofdm symbols
int  tf_sci_cofdm();
// Test put, process, gen for  binary buffer
int  tf_sci_binbuff();
// Test pam_mod pam_dem
int  tf_sci_pam();
// Test timing detector tedg_x
int  tf_sci_tedg_x();

#endif // TF_SCI_HPP

