/*!
* \file
* \author mk
* \brief - define tf - test functons for sci if
*/

#ifndef TF_SCI_IF_HPP
#define TF_SCI_IF_HPP

//! Init MAV fir filter using vector - get impulse response
int tf_sci_if_fir();
//! Init MAV fir filter using vector - get impulse response
int tf_sci_if_xfir();
//! set prbs(2^3-1=7) get 4x7 bits
int tf_sci_if_lfsr();
//! set MOD=4 counter get 4x7 bits
int tf_sci_if_counter();


#ifdef SCI_TEST_FIR
#define tf_sci_if_fun tf_sci_if_fir
#elif SCI_TEST_XFIR
#define tf_sci_if_fun tf_sci_if_xfir
#elif SCI_TEST_LFSR
#define tf_sci_if_fun tf_sci_if_lfsr
#elif SCI_TEST_COUNTER
#define tf_sci_if_fun tf_sci_if_counter
#endif //SCI_TEST_FIR

#endif //TF_SCI_IF_HPP

