/*!
* \brief - master test function for SIM namespace
* \author maki
*/

#ifndef TF_SIM_HPP
#define TF_SIM_HPP

#ifdef SIM_TEST_ALL
#define SIM_TEST_FIR
#define SIM_TEST_FIR_X
#define SIM_TEST_LFSR
#define SIM_TEST_COUNTER
#define SIM_TEST_LSR
#define SIM_TEST_BERT
#define SIM_TEST_QAM
#define SIM_TEST_BIN2INT
#define SIM_TEST_RMS
#define SIM_TEST_WGN
#define SIM_TEST_FIR_UP
#define SIM_TEST_NCO
#define SIM_TEST_EJP
#define SIM_TEST_AMP_X
#define SIM_TEST_MIX_X
#define SIM_TEST_IQ2AP
#define SIM_TEST_CIRCBUFF_X
#define SIM_TEST_PSK
#define SIM_TEST_SRC_X
#define SIM_TEST_COFDM
#define SIM_TEST_PAM
#define SIM_TEST_CASDEC_X
#define SIM_TEST_BINBUFF
#define SIM_TEST_TEDG_X
#endif

//! Master function
int tf_sim();
//! Init fir filter, get impulse response
int tf_sim_fir();
//! Init fir_x filter, get impulse response
int tf_sim_fir_x();
//! Int LFSR as prbs(2^3-1=7) sequence, get 4 periods
int tf_sim_lfsr();
//! Init COUNTER as by 4 get output for 4*4 clocks
int tf_sim_counter();
//! Pass PRBS sequence through linear shift right register
int tf_sim_lsr();
//! Pass PRBS symbols sequence through BERT observing its state
int tf_sim_bert();
//! Modulate and demodulate qam symbols
int tf_sim_qam();
//! Convert 0..N-1 into bvec and back to ivec
int tf_sim_bin2int();
//! Check RMS for DC
int tf_sim_rms();
//! Check RMS of wgn and wgn_x
int tf_sim_wgn();
//! Upsample using MAV filter
int tf_sim_fir_up();
//! Compare nco and vco output for steady input phase step
int tf_sim_nco();
//! Compare ejp output with direct calculation
int tf_sim_ejp();
//! Mix exp(j*p) * exp(-jp)
int tf_sim_mix_x();
//! Modulate and demodulate qam symbols with conversion between
int tf_sim_iq2ap();
//! sample and hold nco output
int tf_sim_amp_x();
//! get src_x impulse response
int tf_sim_src_x();
//! get tedg_x sine response for different modes and phase offset
int tf_sim_tedg_x();
//! test process, put, peek, get for circullar buffer
int tf_sim_circbuff_x();
//! Modulate and demodulate 8PSK symbols
int tf_sim_psk();
//! compare cascaded decimator with equivalent discrete implementation
int tf_sim_casdec_x();
//! modulate demodulate cofdm symbol
int tf_sim_cofdm();
//! convert bytes into the binary symbols
int tf_sim_binbuff();
// modulate and demodulate 8PAM symbols
int tf_sim_pam();

#endif

