/*xxx
 * \brief SCI_AMP API
 * \author maki
 */

#include "sci\sci_amp.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_amp::sci_amp()
{
  debug(3) << "sci_amp created \n";
};

sci_amp::~sci_amp()
{
  debug(3) << "sci_amp destroyed \n";
};

/*! sets parameter of an gain stage \n
<pre>
Supported parameters:
\a SCI_GAIN,    \a sci_var [double] gain \n
\a SCI_OFFSET,  \a sci_var [double] offset \n
\a SCI_OUTPUT,  \a sci_var [double] output value y0 \n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_amp::set(int param, sci_var* p_v)
{
  switch(param)
  {
    case SCI_GAIN:
      debug(3) << "sci_amp::set SCI_GAIN  v=" << p_v->get_double() << endl;
      set_gain(p_v->get_double());
      break;

    case SCI_OFFSET:
      debug(3) << "sci_amp::set SCI_OFFSET v=" << p_v->get_double() << endl;
      set_offset(p_v->get_double());
      break;

    case SCI_OUTPUT:
      debug(3) << "sci_amp::set SCI_OUTPUT v=" << p_v->get_double() << endl;
      set_output(p_v->get_double());
      break;

    default:
      throw sci_exception("sci_amp::set - unknown param");
  }
  return;
};

/*! creates new sci_var and assigns its value to the requested parameter of a gain stage
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int] \n
\a SCI_GAIN,    \a sci_var [double] \n
\a SCI_OFFSET,  \a sci_var [double] \n
\a SCI_OUTPUT,  \a sci_var [complex] output value \n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_amp::get(int param)
{

  switch(param)
  {

    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_AMP;
      debug(3) << "sci_amp::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_GAIN:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      v = get_gain();
      debug(3) << "sci_amp::get SCI_GAIN v =" << v << endl;
      return(p_sci_var_double);
    }

    case SCI_OFFSET:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      v = get_offset();
      debug(3) << "sci_amp::get SCI_OFFSET v =" << v << endl;
      return(p_sci_var_double);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      v = get_output();
      debug(3) << "sci_amp::get SCI_OUTPUT v =" << v << endl;
      return(p_sci_var_double);
    }


    default:
      throw sci_exception("sci_amp::get - unknown param");
  }

};

/*! executes command in an object of an gain stage \n
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_amp::exec(int command)
{
  throw sci_exception("sci_amp::exec - unknown command");
  return;
};

/*! creates sci_var and assign its value to the output of a gain stage [y][vec] 
    by processing input [x][vec] for active [ce][vec] ticks
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x  - sci_var [vec]
\return             - pointer to y - created sci_var [vec]
*/
sci_var* sci_amp::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_vec;
  vec &y = (dynamic_cast<sci_var_vec *>(p_y))->v;

  debug(3) << "sci_amp::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_amp::proc  x = " << p_v_x->get_vec() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_vec());

  debug(3) << "sci_amp::proc  y = " << y << endl;
  return (p_y);
};

} // namespace SCI