/*xxx
* \brief SCI_AMP_X API
* \author maki
*/

#include "sci\sci_amp_x.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_amp_x::sci_amp_x()
{
  debug(3) << "sci_amp_x created \n";
};
sci_amp_x::~sci_amp_x()
{
  debug(3) << "sci_amp_x destroyed \n";
};


/*! sets parameters of a complex gain stage \n
<pre>
Supported parameters:
\a SCI_GAIN,    \a sci_var [double] gain \n
\a SCI_OFFSET,  \a sci_var [double] offset \n
\a SCI_OUTPUT,  \a sci_var [double] output value y0 \n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_amp_x::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_GAIN:
      debug(3) << "sci_amp_x::set SCI_GAIN  v=" << p_v->get_complex() << endl;
      set_gain(p_v->get_complex());
      break;

    case SCI_OFFSET:
      debug(3) << "sci_amp_x::set SCI_OFFSET v=" << p_v->get_complex() << endl;
      set_offset(p_v->get_complex());
      break;

    case SCI_OUTPUT:
      debug(3) << "sci_amp_x::set SCI_OUTPUT v=" << p_v->get_complex() << endl;
      set_output(p_v->get_complex());
      break;

    default:
      throw sci_exception("sci_amp_x::set - unknown param");
  }
  return;
}

/*! creates new sci_var and assigns its value to the requested parameter of a gain stage
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int] \n
\a SCI_GAIN,    \a sci_var [double] \n
\a SCI_OFFSET,  \a sci_var [double] \n
\a SCI_OUTPUT,  \a sci_var [complex] output value \n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_amp_x::get(int param)
{

  switch(param)
  {

    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_AMP_X;
      debug(3) << "sci_amp_x::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_GAIN:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complexd &v = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      v = get_gain();
      debug(3) << "sci_amp_x::get SCI_GAIN v =" << v << endl;
      return(p_sci_var_complex);
    }

    case SCI_OFFSET:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complexd &v = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      v = get_offset();
      debug(3) << "sci_amp_x::get SCI_OFFSET v =" << v << endl;
      return(p_sci_var_complex);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complexd &v = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      v = get_output();
      debug(3) << "sci_amp_x::get SCI_OUTPUT v =" << v << endl;
      return(p_sci_var_complex);
    }

    default:
      throw sci_exception("sci_amp_x::get - unknown param");
  }

};

/*! executes command in na object of a complex gain stage \n
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_amp_x::exec(int command)
{
  throw sci_exception("sci_amp_x::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of a complex gain stage [y][cvec] 
    by processing input [x][cvec] for active [ce][bvec] ticks
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x  - sci_var [cvec]
\return             - pointer to y - created sci_var [cvec]
*/
sci_var* sci_amp_x::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_cvec;
  cvec &y = (dynamic_cast<sci_var_cvec *>(p_y))->v;

  debug(3) << "sci_amp_x::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_amp_x::proc  x = " << p_v_x->get_cvec() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_cvec());

  debug(3) << "sci_amp_x::proc  y = " << y << endl;
  return (p_y);
};



} // namespace SCI