/*xxx
* \brief -  SCI_AP2IQ API
* \author maki
*/

#include "sci\sci_ap2iq.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_ap2iq::sci_ap2iq()
{
  debug(3) << "sci_ap2iq created \n";
};

sci_ap2iq::~sci_ap2iq()
{
  debug(3) << "sci_ap2iq destroyed \n";
};

/*! sets parameters of a SCI_AP2IQ \n
<pre>
Supported parameters:
\a SCI_OUTPUT,      \a sci_var [complex]  output for ce=0\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with the value of the parameter
*/
void sci_ap2iq::set(int param, sci_var* p_v)
{

  switch(param)
  {

    case SCI_OUTPUT:
      debug(3) << " sci_ap2iq::set SCI_OUTPUT  cv = " << p_v->get_complex() << endl;
      set_output(p_v->get_complex());
      break;

    default:
      throw sci_exception("sci_ap2iq::set - unknown param");
  }
  return;
}

/*! creates new sci_var object and assigns its value to a parameter of the SCI_AP2IQ \n
<pre>
Supported parameters:
\a SCI_TYPE,        \a sci_var [int]  \n
\a SCI_OUTPUT,      \a sci_var [complex]  initial output\n
</pre>
\param [in] param   - parameter to get
\return             - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_ap2iq::get(int param)
{

  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_AP2IQ;
      debug(3) << "sci_ap2iq::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complexd &v = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      v = get_output();
      debug(3) << "sci_ap2iq::get SCI_OUTPUT v =" << v << endl;
      return(p_sci_var_complex);
    }

    default:
      throw sci_exception("sci_ap2iq::get - unknown param", param);
  }
};

/*! executes command in an object of a SCI_AP2IQ
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_ap2iq::exec(int command)
{
  throw sci_exception("sci_ap2iq::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::ap2iq::process()\n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x - sci_var [mat]
\return             - pointer to y - new sci_var [cvec]
*/
sci_var* sci_ap2iq::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_cvec;
  cvec &y = (dynamic_cast<sci_var_cvec *>(p_y))->v;

  debug(3) << "sci_ap2iq::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_ap2iq::proc  x = " << p_v_x->get_mat() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_mat());

  debug(3) << "sci_ap2iq::proc  y = " << y << endl;
  return (p_y);

};


} // namespace SCI