/*xxx
* \brief - SCI_BERT API
* \author maki
*/

#include "sci\sci_bert.hpp"
#include "__debug_level.h"
#include "debug.hpp"


namespace SCI
{

sci_bert::sci_bert()
{
  debug(3) << "sci_bert created \n";
};

sci_bert::~sci_bert()
{
  debug(3) << "sci_bert destroyed \n";
};

/*! set parameters of a BERT \n
<pre>
Supported parameters:
\a SCI_LENGTH,      \a sci_var [int]    SIM::bert.set_length()\n
\a SCI_SYMBOL_SIZE, \a sci_var [int]    SIM::bert.set_size()\n
\a SCI_POLY,        \a sci_var [bvec]   SIM::bert.set_poly()\n
\a SCI_PRBS,        \a sci_var [int]    SIM::bert.set_prbs()\n
\a SCI_THRESHOLD,   \a sci_var [int]    SIM::bert.set_threshold()\n
\a SCI_FSM,         \a sci_var [int]    SIM::bert.set_fsm()\n
\a SCI_ADR,         \a sci_var [int]    SIM::bert.set_adr()\n
\a SCI_OUTPUT,      \a sci_var [int]    SIM::bert.set_output()\n
</pre>
\note SET SCI_POLY or SCI_PRBS and SCI_SYMBOL_SIZE, SCI_LENGTH, SCI_THRESHOLDS are necessary configuration
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/

void sci_bert::set(int param, sci_var* p_v)
{

  switch(param)
  {

    case SCI_LENGTH:        // lenght or correlators lsrx,lsry
      set_length(p_v->get_int());
      break;

    case SCI_SYMBOL_SIZE:
      set_symbol_size(p_v->get_int());
      break;

    case SCI_PRBS:
      set_prbs(p_v->get_int());
      break;

    case SCI_POLY:
      set_poly(p_v->get_bvec());
      break;

    case SCI_THRESHOLD:
      set_threshold(p_v->get_ivec());
      break;

    case SCI_FSM:
      set_fsm((bert_fsm_state)p_v->get_int());
      break;

    case SCI_ADR:
      set_adr((bert_adr)p_v->get_int());
      break;

    case SCI_OUTPUT:
      set_output((bert_fsm_state)p_v->get_int());
      break;

    default:
      throw sci_exception("sci_bert::set - unknown param", param);
  }
  return;
};

/*! create new sci_var object and assign its value to BERT parameter
<pre>
Supported parameters:
\a SCI_TYPE,            \a sci_var [int] \n
\a SCI_LENGTH,          \a sci_var [int]    SIM::bert.get_length()\n
\a SCI_SYMBOL_SIZE,     \a sci_var [int]    SIM::bert.get_symbol_size()\n
\a SCI_THRESHOLD,       \a sci_var [ivec]   SIM::bert.get_threshold()\n
\a SCI_CNT,             \a sci_var [ivec]   SIM::bert.get_cnt()\n
\a SCI_ACC_CNT,         \a sci_var [ivec]   SIM::bert.get_acc_cnt()\n
\a SCI_METRICS,         \a sci_var [int]    SIM::bert.get_metrics()\n
\a SCI_FSM,             \a sci_var [int]    SIM::bert.get_fsm()\n
\a SCI_STATE,           \a sci_var [bvec]   SIM::bert.get_state()\n
\a SCI_POLY,            \a sci_var [bvec]   SIM::bert.get_poly()\n
\a SCI_OUTPUT,          \a sci_var [int]    SIM::bert.get_output()\n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_bert::get(int param)
{

  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_BERT;
      debug(3) << "sci_bert::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_LENGTH:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_length();
      debug(3) << "sci_bert::get SCI_LENGTH iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SYMBOL_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_symbol_size();
      debug(3) << "sci_bert::get SCI_SYMBOL_SIZE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_STATE:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &bv = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      bv = get_state();
      debug(3) << "sci_bert::get SCI_STATE bv =" << bv << endl;
      return(p_sci_var_bvec);
    }

    case SCI_POLY:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &bv = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      bv = get_poly();
      debug(3) << "sci_bert::get SCI_POLY bv =" << bv << endl;
      return(p_sci_var_bvec);
    }

    case SCI_THRESHOLD:
    {
      sci_var* p_sci_var_ivec = new sci_var_ivec;
      ivec &iv = (dynamic_cast<sci_var_ivec *>(p_sci_var_ivec))->v;
      iv = get_threshold();
      debug(3) << "sci_bert::get SCI_THRESHOLD iv =" << iv << endl;
      return(p_sci_var_ivec);
    }

    case SCI_CNT:
    {
      sci_var* p_sci_var_ivec = new sci_var_ivec;
      ivec &iv = (dynamic_cast<sci_var_ivec *>(p_sci_var_ivec))->v;
      iv = get_cnt();
      debug(3) << "sci_bert::get SCI_CNT iv =" << iv << endl;
      return(p_sci_var_ivec);
    }

    case SCI_ACC_CNT:
    {
      sci_var* p_sci_var_ivec = new sci_var_ivec;
      ivec &iv = (dynamic_cast<sci_var_ivec *>(p_sci_var_ivec))->v;
      iv = get_acc_cnt();
      debug(3) << "sci_bert::get SCI_ACC_CNT iv =" << iv << endl;
      return(p_sci_var_ivec);
    }

    case SCI_METRICS:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_metrics();
      debug(3) << "sci_bert::get SCI_METRICS iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_FSM:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_fsm();
      debug(3) << "sci_bert::get SCI_FSM iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_output();
      debug(3) << "sci_bert::get SCI_OUTPUT iv =" << iv << endl;
      return(p_sci_var_int);
    }

    default:
      throw sci_exception("sci_bert::get - unknown param", param);
  }
};

/*! execute command for an instance of a BERT
<pre>
Supported commands:
\a SCI_RESET \n
\a SCI_START \n
\a SCI_CLEAR \n
</pre>
\param [in] command - to be executed
*/
void sci_bert::exec(int command)
{
  switch(command)
  {
    case SCI_RESET:
      set_fsm(BERT_FSM_RESET); // BERT_FSM_RESET is a permament state without transitions
      break;

    case SCI_START:
      set_fsm(BERT_FSM_RELOAD); // BERT_FSM_RELOAD is a initial state
      break;

    case SCI_CLEAR:
      clear_counters();
      break;

    default:
      throw sci_exception("sci_bert::exec - unknown command", command);
  }
  return;
};

/*! for active [ce] ticks, shift in x[i,:] symbol into X LSR and generate y[i,:] symbol and shift into Y LSR
\n calculate error bits in x[i,:] with respect to y[i,:] calculate metrics and new \ref BERT_FSM state
\n details: SIM::bert.process()
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x - sci_var [bmat]
\return             - pointer to y - new sci_var [ivec] - \ref BERT_FSM states
*/
sci_var* sci_bert::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_ivec;
  ivec &y = (dynamic_cast<sci_var_ivec *>(p_y))->v;

  debug(3) << "sci_bert::proc ce=" << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_bert::proc  x=" << p_v_x->get_bmat() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_bmat());

  debug(3) << "sci_bert::proc y=" << y << endl;
  return (p_y);
};

} // namespace SCI
