/*xxx
* \brief - SCI_BIN2INT API
* \author maki
*/

#include "sci\sci_bin2int.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{
sci_bin2int::sci_bin2int()
{
  debug(3) << "sci_bin2int created \n";
};

sci_bin2int::~sci_bin2int()
{
  debug(3) << "sci_bin2int destroyed \n";
};

/*! set parameters of a BIN2INT \n
<pre>
Supported parameters:
\a SCI_SYMBOL_SIZE,   \a sci_var [int]  size of the symbol in bits\n
\a SCI_MSB_FLAG,      \a sci_var [bool] msb flag - x[0]=MSB \n
\a SCI_OUTPUT,        \a sci_var [int]  output for ce=0\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_bin2int::set(int param, sci_var* p_v)
{
  switch(param)
  {
    case SCI_SYMBOL_SIZE:
      set_symbol_size(p_v->get_int());
      break;

    case SCI_MSB_FLAG:
      set_msb_flag(p_v->get_bool());
      break;

    case SCI_OUTPUT:
      set_output(p_v->get_int());
      break;

    default:
      throw sci_exception("sci_bin2int::set - unknown param");
  }
  return;
};

/*! create new sci_var object and assign its value to a parameter of the BIN2INT \n
<pre>
Supported parameters:
\a SCI_TYPE,          \a sci_var [int]   \n
\a SCI_SYMBOL_SIZE,   \a sci_var [int]  size of the symbol in bits\n
\a SCI_MSB_FLAG,      \a sci_var [bool] msb flag - x[0]=MSB \n
\a SCI_OUTPUT,        \a sci_var [int]  output for ce=0\n
</pre>
\param [in] param   - parameter to get
\return             - pointer to sci_var object with the value of the parameter
*/

sci_var* sci_bin2int::get(int param)
{

  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_BIN2INT;
      debug(3) << "sci_bin2int::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SYMBOL_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_symbol_size();
      debug(3) << "sci_bin2int::get SCI_SYMBOL_SIZE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_MSB_FLAG:
    {
      sci_var* p_sci_var_bool = new sci_var_bool;
      bool &bv = (dynamic_cast<sci_var_bool *>(p_sci_var_bool))->v;
      bv = get_msb_flag();
      debug(3) << "sci_bin2int::get SCI_MSB_FLAG bv =" << bv << endl;
      return(p_sci_var_bool);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_output();
      debug(3) << "sci_bin2int::get SCI_OUTPUT iv =" << iv << endl;
      return(p_sci_var_int);
    }

    default:
      throw sci_exception("sci_bin2int::get - unknown param");
  }
};

/*! execute command for an instance of a BIN2INT
Supported commands: none
\param [in] command - to be executed
*/
void sci_bin2int::exec(int command)
{
  throw sci_exception("sci_bin2int::exec - unknown command");
  return;
};

/*! for active [ce] ticks, convert bvec x[i,:] into integer y[i]
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x - sci_var [bmat]
\return             - pointer to y - new sci_var [ivec]
*/
sci_var* sci_bin2int::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_ivec;
  ivec &y = (dynamic_cast<sci_var_ivec *>(p_y))->v;


  debug(3) << "sci_bin2int::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_bin2int::proc  x = " << p_v_x->get_bmat() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_bmat());

  debug(3) << "sci_bin2int::proc y = " << y << endl;
  return (p_y);
};

} // namespace SCI
