/*xxx
* \brief -  SCI_BINBUFF API
* \author maki
*/

#include "sci\sci_binbuff.hpp"
#include "__debug_level.h"
#include "debug.hpp"


namespace SCI
{

sci_binbuff::sci_binbuff()
{
  debug(3) << "sci_binbuff \n";
};

sci_binbuff::~sci_binbuff()
{
  debug(3) << "sci_binbuff destroyed \n";
};

/*! sets parameters of a SCI_CIRCBUFF \n
<pre>
Supported parameters:
\a SCI_SIZE,        \a sci_var [int] buffer size in bits\n
\a SCI_SYMBOL_SIZE, \a sci_var [int] symbol size in bits for put()/get() in generate() and process()\n
\a SCI_SINGLETON,   \a sci_var [bool] single bin value to be put into buffer\n
\a SCI_VEC,         \a sci_var [bvec] vector to be put into buffer\n
\a SCI_OUTPUT,      \a sci_var [bvec] output state \n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with the value of the parameter
*/
void sci_binbuff::set(int param, sci_var* p_v)
{
  switch(param)
  {
    case SCI_SIZE:
      SIM::binbuff::set_size(p_v->get_int());
      break;

    case SCI_SYMBOL_SIZE:
      SIM::binbuff::set_symbol_size(p_v->get_int());
      break;

    case SCI_SINGLETON:
      SIM::binbuff::put((bin)p_v->get_bool());
      break;

    case SCI_VEC:
      SIM::binbuff::put(p_v->get_bvec());
      break;

    case SCI_OUTPUT:
      SIM::binbuff::set_output(p_v->get_bvec());
      break;

    default:
      throw sci_exception("sci_binbuff::set - unknown param");
  }
  return;
};

/*! creates new sci_var object and assigns its value to a parameter of the SCI_BINBUFF \n
<pre>
Supported parameters:
\a SCI_TYPE,        \a sci_var [int]  \n
\a SCI_SIZE,        \a sci_var [int] buffer size \n
\b SCI_SYMBOL_SIZE, \a sci_var [int] symbol size in bits for put()/get() in generate() and process() \n
\a SCI_N_OF_ELEM,   \a sci_var [int] number of elements \n
\a SCI_SINGLETON,   \a sci_var [bool] single bin value got from buffer\n
\a SCI_VEC,         \a sci_var [bvec] vector got from buffer\n
\a SCI_PEEK_VEC,    \a sci_var [bvec] vector peeked from buffer\n
\a SCI_PEEK_REV_VEC,\a sci_var [bvec] reversed vector peeked from buffer\n
\a SCI_OUTPUT,      \a sci_var [bvec] output state \n
</pre>
\param [in] param   - parameter to get
\return             - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_binbuff::get(int param)
{

  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_BINBUFF;
      debug(3) << "sci_bincbuff::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SIM::binbuff::get_size();
      debug(3) << "sci_binbuff::get SCI_SIZE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SYMBOL_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SIM::binbuff::get_symbol_size();
      debug(3) << "sci_binbuff::get SCI_SYMBOL_SIZE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_N_OF_ELEM:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SIM::binbuff::nrof_elements();
      debug(3) << "sci_binbuff::get SCI_N_OF_ELEM iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SINGLETON:
    {
      sci_var* p_sci_var_bool = new sci_var_bool;
      bool &v = (dynamic_cast<sci_var_bool *>(p_sci_var_bool))->v;
      v = SIM::binbuff::get();
      debug(3) << "sci_binbuff::get SCI_SINGLETON v =" << v << endl;
      return(p_sci_var_bool);
    }

    case SCI_VEC:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &v = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      SIM::binbuff::get(v, -1);
      debug(3) << "sci_binbuff::get SCI_VEC v =" << v << endl;
      return(p_sci_var_bvec);
    }

    case SCI_PEEK_VEC:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &v = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      SIM::binbuff::peek(v, -1);
      debug(3) << "sci_binbuff::get SCI_PEEK_VEC v =" << v << endl;
      return(p_sci_var_bvec);
    }

    case SCI_PEEK_REV_VEC:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &v = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      SIM::binbuff::peek_reverse(v, -1);
      debug(3) << "sci_binbuff::get SCI_PEEK_REV_VEC v =" << v << endl;
      return(p_sci_var_bvec);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &v = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      v = SIM::binbuff::get_output();
      debug(3) << "sci_binbuff::get SCI_OUTPUT v =" << v << endl;
      return(p_sci_var_bvec);
    }

    default:
      throw sci_exception("sci_binbuff::get - unknown param");
  }

};

/*! executes command in an object of a SCI_BINBUFF
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_binbuff::exec(int command)
{
  throw sci_exception("sci_binbuff::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::binbuff::generate() \n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec][ce]
\return             - pointer to y - new sci_var [bmat]
*/
sci_var* sci_binbuff::gen(sci_var* p_v_ce)
{
  sci_var* p_y = new sci_var_bmat;
  bmat &y = (dynamic_cast<sci_var_bmat *>(p_y))->v;

  debug(3) << "sci_binbuff::gen ce = " << p_v_ce->get_bvec() << endl;

  y = generate(p_v_ce->get_bvec());

  debug(3) << "sci_binbuff::gen  y = " << y << endl;
  return (p_y);
};

/*! creates sci_var and assigns its value to the output of SIM::binbuff::process() \n
\param [in] p_v_ce  - pointer to ce - sci_var [bmat][cei|ceo]
\param [in] p_v_x   - pointer to x - sci_var [bmat]
\return             - pointer to y - new sci_var [bmat]
*/
sci_var* sci_binbuff::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_bmat;
  bmat &y = (dynamic_cast<sci_var_bmat *>(p_y))->v;

  debug(3) << "sci_binbuff::proc ceio = " << p_v_ce->get_bmat() << endl;
  debug(3) << "sci_binbuff::proc    x = " << p_v_x->get_bmat() << endl;

  y = process(p_v_ce->get_bmat(), p_v_x->get_bmat());

  debug(3) << "sci_binbuff::proc    y = " << y << endl;
  return (p_y);
};

} // namespace SCI