/*xxx
* \brief SCI_CASDEC_X - cascaded complex /2 decimators - API
* \author maki
*/

#include "sci\sci_casdec_x.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_casdec_x::sci_casdec_x()
{
  debug(3) << "sci_casdec_x created \n";
};

sci_casdec_x::~sci_casdec_x()
{
  debug(3) << "sci_casdec_x destroyed \n";
};

/*! set parameters of a cascaded /2 complex FIR decimators\n
<pre>
Supported parameters:
\a SCI_ORDER,   \a sci_var [int]\n
\a SCI_RATE,  \a sci_var [int]\n
\a SCI_TAPS, \a sci_var [cvec]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_casdec_x::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_ORDER:
      SIM::casdec_x::set_decimator_order(p_v->get_int());
      break;

    case SCI_RATE:
      SIM::casdec_x::set_decimator_rate(p_v->get_int());
      break;

    case SCI_TAPS:
      SIM::casdec_x::set_taps(p_v->get_cvec());
      break;

    default:
      throw sci_exception("sci_casdec_x::set - unknown param");
  }
  return;
};

/*! create new sci_var object and assign its value to cascaded /2 complex FIR decimators parameter - param
<pre>
Supported parameters:
\a SCI_TYPE,  \a sci_var [int] \n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var
*/
sci_var* sci_casdec_x::get(int param)
{
  switch (param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_CASDEC_X;
      debug(3) << "sci_casdec_x::get SCI_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    default:
      throw sci_exception("sci_casdec_x::get - unknown param");
  }
};

/*! execute command for an instance of a cascaded /2 complex FIR decimators
<pre>
Supported commands:
\a SCI_RESET \n
</pre>
\param [in] command - to be executed
*/
void sci_casdec_x::exec(int command)
{
  switch(command)
  {
    case SCI_RESET:
      SIM::casdec_x::reset();
      break;
    default:
      throw sci_exception("sci_casdec_x::exec - unknown command");
  }
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::casdec_x::process() \n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x  - sci_var [cvec]
\return             - pointer to y - created sci_var [cmat]
*/
sci_var* sci_casdec_x::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_cmat;
  cmat &y = (dynamic_cast<sci_var_cmat *>(p_y))->v;

  debug(3) << "sci_casdec_x::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_casdec_x::proc  x = " << p_v_x->get_cvec() << endl;

  y = SIM::casdec_x::process(p_v_ce->get_bvec(), p_v_x->get_cvec());

  debug(3) << "sci_casdec_x::proc  y = " << y << endl;
  return (p_y);
};

} // namespace SCI