/*xxx
* \brief -  SCI_CIRCBUFF API
* \author maki
*/

#include "sci\sci_circbuff.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_circbuff::sci_circbuff()
{
  debug(3) << "sci_circbuff created \n";
};

sci_circbuff::~sci_circbuff()
{
  debug(3) << "sci_circbuff destroyed \n";
};

/*! sets parameters of a SCI_CIRCBUFF \n
<pre>
Supported parameters:
\a SCI_SIZE,      \a sci_var [int] buffer size\n
\a SCI_SINGLETON, \a sci_var [double] single value to be put into buffer\n
\a SCI_VEC,       \a sci_var [vec] vector to be put into buffer\n
\a SCI_OUTPUT,    \a sci_var [double] output state \n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with the value of the parameter
*/
void sci_circbuff::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_SIZE:
      debug(3) << " sci_circbuff::set SCI_SIZE  v = " << p_v->get_int() << endl;
      SIM::circbuff::set_size(p_v->get_int());
      break;

    case SCI_VEC:
      debug(3) << " sci_circbuff::set SCI_VEC  v = " << p_v->get_vec() << endl;
      SIM::circbuff::put(p_v->get_vec());
      break;

    case SCI_SINGLETON:
      debug(3) << " sci_circbuff_x::set SCI_SINGLETON  v = " << p_v->get_double() << endl;
      SIM::circbuff::put(p_v->get_double());
      break;

    case SCI_OUTPUT:
      debug(3) << " sci_circbuff::set SCI_OUTPUT  v = " << p_v->get_double() << endl;
      SIM::circbuff::set_output(p_v->get_double());
      break;

    default:
      throw sci_exception("sci_circbuff::set - unknown param");
  }
  return;
};

/*! creates new sci_var object and assigns its value to a parameter of the SCI_CIRCBUFF \n
<pre>
Supported parameters:
\a SCI_TYPE,        \a sci_var [int]  \n
\a SCI_SIZE,        \a sci_var [int] buffer size \n
\a SCI_N_OF_ELEM,   \a sci_var [int] number of elements \n
\a SCI_SINGLETON,   \a sci_var [double] single value got from buffer\n
\a SCI_VEC,         \a sci_var [vec] vector got from buffer\n
\a SCI_PEEK_VEC,    \a sci_var [vec] vector peeked from buffer\n
\a SCI_PEEK_REV_VEC,\a sci_var [vec] reversed vector peeked from buffer\n
\a SCI_OUTPUT,      \a sci_var [double] output\n
</pre>
\param [in] param   - parameter to get
\return             - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_circbuff::get(int param)
{

  switch(param)
  {

    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_CIRCBUFF;
      debug(3) << "sci_circbuff::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SIM::circbuff::get_size();
      debug(3) << "sci_circbuff::get SCI_SIZE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_N_OF_ELEM:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SIM::circbuff::nrof_elements();
      debug(3) << "sci_circbuff::get SCI_N_OF_ELEM iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SINGLETON:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      v = SIM::circbuff::get();
      debug(3) << "sci_circbuff::get SCI_SINGLETON v =" << v << endl;
      return(p_sci_var_double);
    }

    case SCI_VEC:
    {
      sci_var* p_sci_var_vec = new sci_var_vec;
      vec &v = (dynamic_cast<sci_var_vec *>(p_sci_var_vec))->v;
      SIM::circbuff::get(v, -1);
      debug(3) << "sci_circbuff::get SCI_VEC v =" << v << endl;
      return(p_sci_var_vec);
    }

    case SCI_PEEK_VEC:
    {
      sci_var* p_sci_var_vec = new sci_var_vec;
      vec &v = (dynamic_cast<sci_var_vec *>(p_sci_var_vec))->v;
      SIM::circbuff::peek(v, -1);
      debug(3) << "sci_circbuff::get SCI_PEEK_VEC v =" << v << endl;
      return(p_sci_var_vec);
    }

    case SCI_PEEK_REV_VEC:
    {
      sci_var* p_sci_var_vec = new sci_var_vec;
      vec &v = (dynamic_cast<sci_var_vec *>(p_sci_var_vec))->v;
      SIM::circbuff::peek_reverse(v, -1);
      debug(3) << "sci_circbuff::get SCI_PEEK_REV_VEC v =" << v << endl;
      return(p_sci_var_vec);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      v = SIM::circbuff::get_output();
      debug(3) << "sci_circbuff::get SCI_OUTPUT v =" << v << endl;
      return(p_sci_var_double);
    }

    default:
      throw sci_exception("sci_circbuff::get - unknown param");
  }

};

/*! executes command in an object of a SCI_CIRCBUFF
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_circbuff::exec(int command)
{
  throw sci_exception("sci_circbuff::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::circbuff::generate() \n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec][ce]
\return             - pointer to y - new sci_var [vec]
*/
sci_var* sci_circbuff::gen(sci_var* p_v_ce)
{
  sci_var* p_y = new sci_var_vec;
  vec &y = (dynamic_cast<sci_var_vec *>(p_y))->v;

  debug(3) << "sci_circbuff::gen ce = " << p_v_ce->get_bvec() << endl;

  y = SIM::circbuff::generate(p_v_ce->get_bvec());

  debug(3) << "sci_circbuff::gen  y = " << y << endl;

  return (p_y);
};

/*! creates sci_var and assigns its value to the output of SIM::circbuff::process() \n
\param [in] p_v_ce  - pointer to ce - sci_var [bmat][cei|ceo]
\param [in] p_v_x   - pointer to x - sci_var [vec]
\return             - pointer to y - new sci_var [vec]
*/
sci_var* sci_circbuff::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_vec;
  vec &y = (dynamic_cast<sci_var_vec *>(p_y))->v;

  debug(3) << "sci_circbuff::proc ceio = " << p_v_ce->get_bmat() << endl;
  debug(3) << "sci_circbuff::proc    x = " << p_v_x->get_vec() << endl;

  y = SIM::circbuff::process(p_v_ce->get_bmat(), p_v_x->get_vec());

  debug(3) << "sci_circbuff::proc    y = " << y << endl;
  return (p_y);
};

} // namespace SCI