/*xxx
* \brief -  SCI_CIRCBUFF_X API
* \author maki
*/

#include "sci\sci_circbuff_x.hpp"
#include "__debug_level.h"
#include "debug.hpp"


namespace SCI
{

sci_circbuff_x::sci_circbuff_x()
{
  debug(3) << "sci_circbuff_x created \n";
};

sci_circbuff_x::~sci_circbuff_x()
{
  debug(3) << "sci_circbuff_x destroyed \n";
};

/*! sets parameters of a SCI_CIRCBUFF_X \n
<pre>
Supported parameters:
\a SCI_SIZE,      \a sci_var [int]  buffer size\n
\a SCI_SINGLETON, \a sci_var [complex]  single value to be put into buffer\n
\a SCI_VEC,       \a sci_var [vec]  vector to be put into buffer\n
\a SCI_OUTPUT,    \a sci_var [complex]  output for ce=0\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with the value of the parameter
*/
void sci_circbuff_x::set(int param, sci_var* p_v)
{
  switch(param)
  {
    case SCI_SIZE:
      debug(3) << " sci_circbuff_x::set SCI_SIZE  v = " << p_v->get_int() << endl;
      SIM::circbuff_x::set_size(p_v->get_int());
      break;

    case SCI_VEC:
      debug(3) << " sci_circbuff_x::set SCI_VEC  v = " << p_v->get_cvec() << endl;
      SIM::circbuff_x::put(p_v->get_cvec());
      break;

    case SCI_SINGLETON:
      debug(3) << " sci_circbuff_x::set SCI_SINGLETON  v = " << p_v->get_complex() << endl;
      SIM::circbuff_x::put(p_v->get_complex());
      break;

    case SCI_OUTPUT:
      debug(3) << " sci_circbuff_x::set SCI_OUTPUT  v = " << p_v->get_double() << endl;
      SIM::circbuff_x::set_output(p_v->get_complex());
      break;

    default:
      throw sci_exception("sci_circbuff_x::set - unknown param");
  }
  return;
};

/*! creates new sci_var object and assigns its value to a parameter of the SCI_CIRCBUFF_X \n
<pre>
Supported parameters:
\a SCI_TYPE,        \a sci_var [int]  \n
\a SCI_SIZE,        \a sci_var [int] buffer size\n
\a SCI_N_OF_ELEM,   \a sci_var [int] number of elements \n
\a SCI_SINGLETON,   \a sci_var [complex] single value got from buffer\n
\a SCI_VEC,         \a sci_var [cvec] vector got from buffer\n
\a SCI_PEEK_VEC,    \a sci_var [cvec] vector peeked from buffer\n
\a SCI_PEEK_REV_VEC,\a sci_var [cvec] reversed vector peeked from buffer\n
\a SCI_OUTPUT,      \a sci_var [complex] output\n
</pre>
\param [in] param   - parameter to get
\return             - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_circbuff_x::get(int param)
{

  switch(param)
  {

    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_CIRCBUFF_X;
      debug(3) << "sci_circbuff_x::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SIM::circbuff_x::get_size();
      debug(3) << "sci_circbuff_x::get SCI_SIZE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_N_OF_ELEM:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SIM::circbuff_x::nrof_elements();
      debug(3) << "sci_circbuff_x::get SCI_N_OF_ELEM iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SINGLETON:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complexd &v = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      v = SIM::circbuff_x::get();
      debug(3) << "sci_circbuffxc::get SCI_SINGLETON v =" << v << endl;
      return(p_sci_var_complex);
    }

    case SCI_VEC:
    {
      sci_var* p_sci_var_cvec = new sci_var_cvec;
      cvec &v = (dynamic_cast<sci_var_cvec *>(p_sci_var_cvec))->v;
      SIM::circbuff_x::get(v, -1);
      debug(3) << "sci_circbuffxc::get SCI_VEC v =" << v << endl;
      return(p_sci_var_cvec);
    }

    case SCI_PEEK_VEC:
    {
      sci_var* p_sci_var_cvec = new sci_var_cvec;
      cvec &v = (dynamic_cast<sci_var_cvec *>(p_sci_var_cvec))->v;
      SIM::circbuff_x::peek(v, -1);
      debug(3) << "sci_circbuff_x::get SCI_PEEK_VEC v =" << v << endl;
      return(p_sci_var_cvec);
    }

    case SCI_PEEK_REV_VEC:
    {
      sci_var* p_sci_var_cvec = new sci_var_cvec;
      cvec &v = (dynamic_cast<sci_var_cvec *>(p_sci_var_cvec))->v;
      SIM::circbuff_x::peek_reverse(v, -1);
      debug(3) << "sci_circbuff_x::get SCI_PEEK_REV_VEC v =" << v << endl;
      return(p_sci_var_cvec);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complexd &v = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      v = SIM::circbuff_x::get_output();
      debug(3) << "sci_circbuff_x::get SCI_OUTPUT v =" << v << endl;
      return(p_sci_var_complex);
    }

    default:
      throw sci_exception("sci_circbuff_x::get - unknown param");
  }

};

/*! executes command in an object of a SCI_CIRCBUFF_X
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_circbuff_x::exec(int command)
{
  throw sci_exception("sci_circbuff_x::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::circbuff_x::generate() \n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec][ce]
\return             - pointer to y - new sci_var [cvec]
*/
sci_var* sci_circbuff_x::gen(sci_var* p_v_ce)
{
  sci_var* p_y = new sci_var_cvec;
  cvec &y = (dynamic_cast<sci_var_cvec *>(p_y))->v;

  debug(3) << "sci_circbuff_x::gen ce = " << p_v_ce->get_bvec() << endl;

  y = SIM::circbuff_x::generate(p_v_ce->get_bvec());

  debug(3) << "sci_circbuff_x::gen  y = " << y << endl;
  return (p_y);
};


/*! creates sci_var and assigns its value to the output of SIM::circbuff_x::process() \n 
\param [in] p_v_ce  - pointer to ce - sci_var [bmat][cei|ceo]
\param [in] p_v_x   - pointer to x - sci_var [cvec]
\return             - pointer to y - new sci_var [cvec]
*/
sci_var* sci_circbuff_x::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_cvec;
  cvec &y = (dynamic_cast<sci_var_cvec *>(p_y))->v;

  debug(3) << "sci_circbuff_x::proc ceio = " << p_v_ce->get_bmat() << endl;
  debug(3) << "sci_circbuff_x::proc    x = " << p_v_x->get_cvec() << endl;

  y = SIM::circbuff_x::process(p_v_ce->get_bmat(), p_v_x->get_cvec());

  debug(3) << "sci_circbuff_x::proc    y = " << y << endl;
  return (p_y);
};

} // namespace SCI