/*xxx
* \brief - SCI_COFDM_DEM API
* \author maki
*/

#include "sci\sci_cofdm_dem.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_cofdm_dem::sci_cofdm_dem()
{
  debug(3) << "sci_cofdm_dem created \n";
};
sci_cofdm_dem::~sci_cofdm_dem()
{
  debug(3) << "sci_cofdm_dem destroyed \n";
};

/*! sets parameters of a SCI_COFDM_DEM \n
<pre>
Supported parameters:
\a SCI_COFDM_NFFT,        \a sci_var [int] FFT size \n
\a SCI_COFDM_CP,          \a sci_var [int] CP (Circular Prefix) size \n
\a SCI_SCALE,             \a sci_var [double] scaling factor\n
\a SCI_COFDM_SYMBOL,      \a sci_var [cvec] demodulator input [CP|INV_FFT(carriers)]\n
\a SCI_OUTPUT,            \a sci_var [cvec] y0 - demodulator output - carriers QAM|BPSK [I+jQ]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with the value of the parameter
*/
void sci_cofdm_dem::set(int param, sci_var* p_v)
{
  switch(param)
  {
    case SCI_COFDM_NFFT:
      set_NFFT(p_v->get_int());
      break;
    case SCI_COFDM_CP:
      set_CP(p_v->get_int());
      break;

    case SCI_SCALE:
      set_scale(p_v->get_double());
      break;

    case SCI_COFDM_SYMBOL:
      set_symbol(p_v->get_cvec());
      break;

    case SCI_OUTPUT:
      y0 = p_v->get_cvec();
      break;

    default:
      throw sci_exception("sci_cofdm_dem::set - unknown param");
  }
  return;
};

/*! creates new sci_var object and assigns its value to a parameter of the SCI_COFDM_DEM \n
<pre>
Supported parameters:
\a SCI_TYPE,            \a sci_var [int]  \n
\a SCI_COFDM_NFFT,      \a sci_var [int]  FFT size \n
\a SCI_COFDM_CP,        \a sci_var [int]  (Circular Prefix) size\n
\a SCI_SCALE,           \a sci_var [double] scaling factor\n
\a SCI_COFDM_CARRIERS,  \a sci_var [cvec] demodulator output QAM|BPSK [I+jQ]\n
\a SCI_COFDM_SYMBOL,    \a sci_var [cvec] demodulator input [CP|INV_FFT(carriers)] \n
\a SCI_OUTPUT,          \a sci_var [cvec] state of demodulator output - passive call - does not process symbol\n
</pre>
\param [in] param   - parameter to get
\return             - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_cofdm_dem::get(int param)
{
  switch (param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_COFDM_DEM;
      debug(3) << "sci_cofdm_dem::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_COFDM_NFFT:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_NFFT();
      debug(3) << "sci_cofdm_dem::get SCI_COFDM_NFFT iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_COFDM_CP:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_CP();
      debug(3) << "sci_cofdm_dem::get SCI_COFDM_CP iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SCALE:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      v = get_scale();
      debug(3) << "sci_cofdm_dem::get SCI_SCALE v =" << v << endl;
      return(p_sci_var_double);
    }

    case SCI_COFDM_CARRIERS:
    {
      sci_var* p_sci_var_cvec = new sci_var_cvec;
      cvec &cv = (dynamic_cast<sci_var_cvec *>(p_sci_var_cvec))->v;
      cv = get_carriers();
      debug(3) << "sci_cofdm_dem::get SCI_COFDM_CARRIERS cv =" << cv << endl;
      return(p_sci_var_cvec);
    }

    case SCI_COFDM_SYMBOL:
    {
      sci_var* p_sci_var_cvec = new sci_var_cvec;
      cvec &cv = (dynamic_cast<sci_var_cvec *>(p_sci_var_cvec))->v;
      cv = get_symbol();
      debug(3) << "sci_cofdm_dem::get SCI_COFDM_SYMBOL cv =" << cv << endl;
      return(p_sci_var_cvec);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_cvec = new sci_var_cvec;
      cvec &cv = (dynamic_cast<sci_var_cvec *>(p_sci_var_cvec))->v;
      cv = y0;
      debug(3) << "sci_cofdm_dem::get SCI_OUTPUT cv =" << cv << endl;
      return(p_sci_var_cvec);
    }

    default:
      throw sci_exception("sci_cofdm_dem::get - unknown param");
  }
};

/*! executes command in SCI_COFDM_DEM object
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_cofdm_dem::exec(int command)
{

  throw sci_exception("sci_cofdm_dem::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::cofdm_dem::process()\n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x - sci_var [cmat]
\return             - pointer to y - new sci_var [cmat]
*/
sci_var* sci_cofdm_dem::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_cmat;
  cmat &y = (dynamic_cast<sci_var_cmat *>(p_y))->v;

  debug(3) << "sci_cofdm_mod::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_cofdm_mod::proc  x = " << p_v_x->get_cmat() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_cmat());

  debug(3) << "sci_cofdm_mod::proc  y = " << y << endl;

  return (p_y);
};


} // namespace SCI
