/*xxx
* \brief - SCI_COFDM_DEMAP API
* \author maki
*/

#include "sci\sci_cofdm_demap.hpp"
#include "__debug_level.h"
#include "debug.hpp"


namespace SCI
{

sci_cofdm_demap::sci_cofdm_demap()
{
  debug(3) << "sci_cofdm_demap created \n";
};
sci_cofdm_demap::~sci_cofdm_demap()
{
  debug(3) << "sci_cofdm_demap destroyed \n";
};

/*! sets parameters of a SCI_COFDM_DEMAP \n
<pre>
Supported parameters:
\a SCI_COFDM_NFFT,            \a sci_var [int] FFT size \n
\a SCI_COFDM_QAM_SIZE,        \a sci_var [int] QAM constellation size \n
\a SCI_COFDM_DATA_INDEXES,    \a sci_var [ivec] data carrier indexes  \n
\a SCI_COFDM_PILOT_INDEXES,   \a sci_var [ivec] pilot carrier indexes  \n
\a SCI_COFDM_ZERO_INDEXES,    \a sci_var [ivec] pilot carrier indexes  \n
\a SCI_COFDM_CARRIERS,        \a sci_var [cvec] demapper input QAM|BPSK [I+jQ] \n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with the value of the parameter
*/
void sci_cofdm_demap::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_COFDM_NFFT:		// NFFT size
      set_NFFT(p_v->get_int());
      break;

    case SCI_COFDM_QAM_SIZE:		// CP size
      set_qam_size(p_v->get_int());
      break;

    case SCI_COFDM_PA:
      set_PA(p_v->get_double());
      break;

    case SCI_COFDM_DATA_INDEXES:
      set_data_carriers(p_v->get_ivec());
      break;

    case SCI_COFDM_PILOT_INDEXES:
      set_pilots_carriers(p_v->get_ivec());
      break;

    case SCI_COFDM_ZERO_INDEXES:
      set_zero_carriers(p_v->get_ivec());
      break;

    case SCI_COFDM_CARRIERS:
      set_carriers(p_v->get_cvec());
      break;

    default:
      throw sci_exception("sci_cofdm_demap::set - unknown param");
  }
  return;
};

/*! creates new sci_var object and assigns its value to a parameter of the SCI_COFDM_DEMAP \n
<pre>
Supported parameters:
\a SCI_TYPE,            \a sci_var [int]  \n
\a SCI_COFDM_DATA,      \a sci_var [ivec] demapped QAM codes\n
\a SCI_COFDM_PILOTS,    \a sci_var [bvec] state of mapper output - passive call - does not process carriers\n
\a SCI_OUTPUT,          \a sci_var [ivec] state of demapper output - passive call - does not process carriers\n
</pre>
\param [in] param   - parameter to get
\return             - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_cofdm_demap::get(int param)
{


  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_COFDM_DEMAP;
      debug(3) << "sci_cofdm_demap::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_COFDM_DATA:
    {
      sci_var* p_sci_var_ivec = new sci_var_ivec;
      ivec &iv = (dynamic_cast<sci_var_ivec *>(p_sci_var_ivec))->v;
      iv = get_data();
      return(p_sci_var_ivec);
    }

    case SCI_COFDM_PILOTS:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &bv = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      bv = get_pilots();
      return(p_sci_var_bvec);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_ivec = new sci_var_ivec;
      ivec &iv = (dynamic_cast<sci_var_ivec *>(p_sci_var_ivec))->v;
      iv = y0;
      return(p_sci_var_ivec);
    }

    default:
      throw sci_exception("sci_cofdm_demap::get - unknown param");
  }
};

/*! executes command in SCI_COFDM_DEMAP object
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_cofdm_demap::exec(int command)
{

  throw sci_exception("sci_cofdm_demap::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::cofdm_demap::process()\n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x - sci_var [cmat]
\return             - pointer to y - new sci_var [imat]
*/
sci_var* sci_cofdm_demap::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_imat;
  imat &y = (dynamic_cast<sci_var_imat *>(p_y))->v;

  debug(3) << "sci_cofdm_demap::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_cofdm_demap::proc  x = " << p_v_x->get_cmat() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_cmat());

  debug(3) << "sci_cofdm_demap::proc  y = " << y << endl;

  return (p_y);
};


} // namespace SCI
