/*xxx
* \brief - SCI_COFDM_MAP API
* \author maki
*/

#include "sci\sci_cofdm_map.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_cofdm_map::sci_cofdm_map()
{
  debug(3) << "sci_cofdm_map created \n";
};
sci_cofdm_map::~sci_cofdm_map()
{
  debug(3) << "sci_cofdm_map destroyed \n";
};

/*! sets parameters of a SCI_COFDM_MAP \n
<pre>
Supported parameters:
\a SCI_COFDM_NFFT,            \a sci_var [int] FFT size \n
\a SCI_COFDM_QAM_SIZE,        \a sci_var [int] QAM constellation size \n
\a SCI_COFDM_DATA_INDEXES,   \a sci_var [ivec] data carrier indexes  \n
\a SCI_COFDM_PILOT_INDEXES,   \a sci_var [ivec] pilot carrier indexes  \n
\a SCI_COFDM_ZERO_INDEXES,   \a sci_var [ivec] pilot carrier indexes  \n
\a SCI_COFDM_CARRIERS,    \a sci_var [cvec] modulator input QAM|BPSK [I+jQ] \n
\a SCI_OUTPUT,            \a sci_var [cvec] y0 - COFDM symbol - modulated carriers [CP|INV_FFT(carriers)] \n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with the value of the parameter
*/
void sci_cofdm_map::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_COFDM_NFFT:
      set_NFFT(p_v->get_int());
      break;

    case SCI_COFDM_QAM_SIZE:
      set_qam_size(p_v->get_int());
      break;

    case SCI_COFDM_PA:
      set_PA(p_v->get_double());
      break;

    case SCI_COFDM_DATA_INDEXES:
      set_data_carriers(p_v->get_ivec());
      break;

    case SCI_COFDM_PILOT_INDEXES:
      set_pilots_carriers(p_v->get_ivec());
      break;

    case SCI_COFDM_ZERO_INDEXES:
      set_zero_carriers(p_v->get_ivec());
      break;

    case SCI_COFDM_DATA:
      set_data(p_v->get_ivec());
      break;

    case SCI_COFDM_PILOTS:
      set_pilots(p_v->get_bvec());
      break;


    default:
      throw sci_exception("sci_cofdm_map::set - unknown param");
  }
  return;
};

/*! creates new sci_var object and assigns its value to a parameter of the SCI_COFDM_MAP \n
<pre>
Supported parameters:
\a SCI_TYPE,            \a sci_var [int]  \n
\a SCI_COFDM_CARRIERS,  \a sci_var [cvec] modulator input QAM|BPSK [I+jQ]\n
\a SCI_OUTPUT,          \a sci_var [cvec] state of mapper output - passive call - does not process carriers\n
</pre>
\param [in] param   - parameter to get
\return             - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_cofdm_map::get(int param)
{

  switch (param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_COFDM_MAP;
      debug(3) << "sci_cofdm_map::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_COFDM_CARRIERS:
    {
      sci_var* p_sci_var_cvec = new sci_var_cvec;
      cvec &cv = (dynamic_cast<sci_var_cvec *>(p_sci_var_cvec))->v;
      cv = get_carriers();
      debug(3) << "sci_cofdm_map::get SCI_COFDM_CARRIERS cv =" << cv << endl;
      return(p_sci_var_cvec);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_cvec = new sci_var_cvec;
      cvec &cv = (dynamic_cast<sci_var_cvec *>(p_sci_var_cvec))->v;
      cv = y0;
      debug(3) << "sci_cofdm_map::get SCI_OUTPUT cv =" << cv << endl;
      return(p_sci_var_cvec);
    }

    default:
      throw sci_exception("sci_cofdm_map::get - unknown param");
  }
};

/*! executes command in SCI_COFDM_MAP object
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_cofdm_map::exec(int command)
{

  throw sci_exception("sci_cofdm_map::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::cofdm_map::process()\n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x - sci_var [imat]
\return             - pointer to y - new sci_var [cmat]
*/
sci_var* sci_cofdm_map::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_cmat;
  cmat &y = (dynamic_cast<sci_var_cmat *>(p_y))->v;

  debug(3) << "sci_cofdm_map::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_cofdm_map::proc  x = " << p_v_x->get_imat() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_imat());

  debug(3) << "sci_cofdm_map::proc  y = " << y << endl;

  return (p_y);
};

} // namespace SCI
