/*xxx
* \brief - SCI_COFDM_SEL API
* \author maki
*/

#include "sci\sci_cofdm_sel.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_cofdm_sel::sci_cofdm_sel()
{
  debug(3) << "sci_cofdm_sel created \n";
};

sci_cofdm_sel::~sci_cofdm_sel()
{
  debug(3) << "sci_cofdm_sel destroyed \n";
};

/*! sets parameters of a SCI_COFDM_SEL \n
<pre>
Supported parameters:
\a SCI_COFDM_NFFT,          \a sci_var [int] FFT size \n
\a SCI_COFDM_SEL_INDEXES,   \a sci_var [ivec] selected carrier indexes  \n
\a SCI_COFDM_CARRIERS,      \a sci_var [cvec] QAM|BPSK [I+jQ] carriers \n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with the value of the parameter
*/
void sci_cofdm_sel::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_COFDM_NFFT:		// NFFT size
      set_NFFT(p_v->get_int());
      break;

    case SCI_COFDM_SEL_INDEXES:
      set_carriers_selector(p_v->get_ivec());
      break;

    case SCI_COFDM_CARRIERS:
      set_carriers(p_v->get_cvec());
      break;

    default:
      throw sci_exception("sci_cofdm_sel::set - unknown param");
  }
  return;
};

/*! creates new sci_var object and assigns its value to a parameter of the SCI_COFDM_SEL \n
<pre>
Supported parameters:
\a SCI_TYPE,                  \a sci_var [int]  \n
\a SCI_COFDM_SEL_CARRIERS,    \a sci_var [cvec] demapped QAM codes\n
</pre>
\param [in] param   - parameter to get
\return             - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_cofdm_sel::get(int param)
{

  switch(param)
  {

    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_COFDM_SEL;
      debug(3) << "sci_cofdm_sel::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_COFDM_SEL_CARRIERS:
    {
      sci_var* p_sci_var_cvec = new sci_var_cvec;
      cvec &cv = (dynamic_cast<sci_var_cvec *>(p_sci_var_cvec))->v;
      cv = get_selected_carriers();
      return(p_sci_var_cvec);
    }

    default:
      throw sci_exception("sci_cofdm_sel::get - unknown param");
  }
};

/*! executes command in SCI_COFDM_SEL object
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_cofdm_sel::exec(int command)
{

  throw sci_exception("sci_cofdm_sel::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::cofdm_sel::process()\n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x - sci_var [cmat]
\return             - pointer to y - new sci_var [cmat]
*/
sci_var* sci_cofdm_sel::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_cmat;
  cmat &y = (dynamic_cast<sci_var_cmat *>(p_y))->v;

  debug(3) << "sci_cofdm_sel::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_cofdm_sel::proc  x = " << p_v_x->get_cmat() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_cmat());

  debug(3) << "sci_cofdm_sel::proc  y = " << y << endl;

  return (p_y);
};


} // namespace SCI
