/*xxx
* \brief - SCI_COUNTER API
* \author maki
*/

#include "sci\sci_counter.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_counter::sci_counter()
{
  debug(3) << "sci_counter created \n";
};

sci_counter::~sci_counter()
{
  debug(3) << "sci_counter destroyed \n";
};

/*! set parameters of a counter \n
<pre>
Supported parameters:
\a SCI_PARAM_N, \a sci_var [int]\n
\a SCI_STATE,   \a sci_var [int]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_counter::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_PARAM_N:
      debug(3) << "sci_counter::set SCI_PARAM_N N=" << p_v->get_int() << endl;
      set_N(p_v->get_int());
      break;

    case SCI_STATE:
      debug(3) << "sci_counter::set SCI_STATE state=" << p_v->get_int() << endl;
      set_state(p_v->get_int());
      break;
    default:
      throw sci_exception("sci_counter::set - unknown param");
      break;
  }
  return;
};

/*! create new sci_var object and assign its value to counter parameter param
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int] \n
\a SCI_PARAM_N, \a sci_var [int]\n
\a SCI_STATE,   \a sci_var [int] \n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_counter::get(int param)
{

  switch(param)
  {


    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_COUNTER;
      debug(3) << "sci_counter::get SCI_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_PARAM_N:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_N();
      debug(3) << "sci_counter::get SCI_PARAM_N N=" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_STATE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_state();
      debug(3) << "sci_counter::get SCI_STATE state=" << iv << endl;
      return(p_sci_var_int);
    }

    default:
      throw sci_exception("sci_counter::get - unknown param");
  }

};

/*! execute counter command
<pre>
Supported commands:
\a SCI_RESET \n
</pre>
\param [in] command - to be executed
*/
void sci_counter::exec(int command)
{
  switch(command)
  {
    case SCI_RESET:
      reset();
      debug(3) << "sci_counter::exec(SCI_RESET)" << endl;
      break;
    default:
      throw sci_exception("sci_counter::exec - unknown command");
      break;
  }
};

/*! for active [ce] ticks, increment state modulo N, output carry flag as bit in bvec
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\return             - pointer to y - new sci_var [bvec]
*/
sci_var* sci_counter::gen(sci_var* p_v_ce)
{
  sci_var* p_y = new sci_var_bvec;
  bvec &y = (dynamic_cast<sci_var_bvec *>(p_y))->v;

  debug(3) << "sci_counter::gen ce=" << p_v_ce->get_bvec() << endl;
  y = generate(p_v_ce->get_bvec());
  debug(3) << "sci_counter::gen y = " << y << endl;
  return (p_y);

};

}