/*xxx
 * \brief SCI_EJP API
 * \author maki
 */

#include "sci\sci_ejp.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_ejp::sci_ejp()
{
  debug(3) << "sci_ejp created \n";
};

sci_ejp::~sci_ejp()
{
  debug(3) << "sci_ejp destroyed \n";
};

/*! set parameters of a complex sine generator \n
<pre>
Supported parameters:
\a SCI_OUTPUT,  \a sci_var [complex] initial output value y0 = [cos()+jsin()]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/

void sci_ejp::set(int param, sci_var* p_v)
{

  switch(param)
  {

    case SCI_OUTPUT:
      debug(3) << "sci_ejp::set SCI_OUTPUT  v = " << p_v->get_complex() << endl;
      set_output(p_v->get_complex());
      break;

    default:
      throw sci_exception("sci_ejp::set - unknown param");
  }
  return;
}

/*! create new sci_var object and assign a its value to parameter of complex sine generator
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int] \n
\a SCI_OUTPUT,  \a sci_var [complex] initial output value y0 = [cos()+jsin()]\n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_ejp::get(int param)
{

  switch(param)
  {

    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_EJP;
      debug(3) << "sci_ejp::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complexd &v = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      v = get_output();
      debug(3) << "sci_ejp::get SCI_OUTPUT v =" << v << endl;
      return(p_sci_var_complex);
    }

    default:
      throw sci_exception("sci_ejp::get - unknown param");
  }
};

/*! execute command for an instance of complex sine generator \n
Supported commands:\n
none
\param [in] command - to be executed
 */
void sci_ejp::exec(int command)
{
  throw sci_exception("sci_ejp::exec - unknown command");
  return;
};

/*! return output of complex sine generator [y]=[exp(j*2pi*x)] in newly created sci_var [cvec]\n
for active [ce] ticks, calculate complex sine for normalized phase in [x]
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x  - sci_var [vec]
\return             - pointer to y - created sci_var [cvec] = [cos(2pi*x)+jsin(2pi*x)]
*/
sci_var* sci_ejp::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_cvec;
  cvec &y = (dynamic_cast<sci_var_cvec *>(p_y))->v;

  debug(3) << " sci_ejp::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << " sci_ejp::proc  x = " << p_v_x->get_vec() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_vec());

  debug(3) << " sci_ejp::proc  y = " << y << endl;

  return (p_y);

};


} // namespace SCI