/*xxx
* \brief - SCI_FIR API
* \author maki
*/

#include "sci\sci_fir.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_fir::sci_fir()
{
  debug(3) << "sci_fir created \n";
};

sci_fir::~sci_fir()
{
  debug(3) << "sci_fir destroyed \n";
};

/*! sets parameter of a FIR filter \n
<pre>
Supported parameters:
\a SCI_TAPS,   \a sci_var [vec]\n
\a SCI_STATE,  \a sci_var [vec]\n
\a SCI_OUTPUT, \a sci_var [double]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_fir::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_TAPS:
      debug(3) << "sci_fir::set SCI_TAPS v=" << p_v->get_vec() << endl;
      set_taps(p_v->get_vec());
      break;

    case SCI_STATE:
      debug(3) << "sci_fir::set SCI_STATE v=" << p_v->get_vec() << endl;
      set_state(p_v->get_vec());
      break;

    case SCI_OUTPUT:
      debug(3) << "sci_fir::set SCI_OUTPUT v=" << p_v->get_double() << endl;
      set_output(p_v->get_double());
      break;

    default:
      throw sci_exception("sci_fir::set - unknown param");
  }
  return;
};

/*! creates new sci_var and assigns its value to the requested parameter of FIR filter  
<pre>
Supported parameters:
\a SCI_TYPE,  \a sci_var [int] \n
\a SCI_SIZE,  \a sci_var [int] \n
\a SCI_TAPS,  \a sci_var [vec] \n
\a SCI_STATE, \a sci_var [vec] \n
\a SCI_OUTPUT \a sci_var [double] \n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var
*/
sci_var* sci_fir::get(int param)
{
  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_FIR;
      debug(3) << "sci_fir::get SCI_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_size();
      debug(3) << "sci_fir::get SCI_SIZE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_TAPS:
    {
      sci_var* p_sci_var_vec = new sci_var_vec;
      vec &v = (dynamic_cast<sci_var_vec *>(p_sci_var_vec))->v;
      v = get_taps();
      debug(3) << "sci_fir::get SCI_TAPS v=" << p_sci_var_vec->get_vec() << endl;
      return(p_sci_var_vec);
    }

    case SCI_STATE:
    {
      sci_var* p_sci_var_vec = new sci_var_vec;
      vec &v = (dynamic_cast<sci_var_vec *>(p_sci_var_vec))->v;
      v = get_state();
      debug(3) << "sci_fir::get SCI_STATE v=" << p_sci_var_vec->get_vec() << endl;
      return(p_sci_var_vec);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &dv = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      dv = y0;
      debug(3) << "sci_fir::get SCI_OUTPUT v = " << p_sci_var_double->get_double() << endl;
      return(p_sci_var_double);
    }

    default:
      throw sci_exception("sci_fir::get - unknown param");
  }

};

/*! executes command in an object of a FIR filter 
<pre>
Supported commands:
\a SCI_RESET \n
</pre>
\param [in] command - to be executed
*/
void sci_fir::exec(int command)
{
  switch(command)
  {
    case SCI_RESET:
      reset();
      set_output(0.0);
      break;

    default:
      throw sci_exception("sci_fir::exec - unknown command");
  }
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::fir::process() \n  
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x  - sci_var [vec]
\return             - pointer to y - created sci_var [vec]
*/
sci_var* sci_fir::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_vec;
  vec &y = (dynamic_cast<sci_var_vec *>(p_y))->v;

  debug(3) << "sci_fir::proc ce= " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_fir::proc  x= " << p_v_x->get_vec() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_vec());

  debug(3) << "sci_fir::proc  y= " << y << endl;
  return (p_y);
};

} // namespace SCI