/*xxx
* \brief SCI_FIR_X API
* \author maki
*/

#include "sci\sci_fir_x.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_fir_x::sci_fir_x()
{
  debug(3) << "sci_fir_x created \n";
};

sci_fir_x::~sci_fir_x()
{
  debug(3) << "sci_fir_x destroyed \n";
};

/*! sets parameters of a complex FIR filter \n
<pre>
Supported parameters:
\a SCI_TAPS,   \a sci_var [cvec]\n
\a SCI_STATE,  \a sci_var [cvec]\n
\a SCI_OUTPUT, \a sci_var [complex]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_fir_x::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_TAPS:
      debug(3) << "sci_fir_x::set SCI_TAPS cv = " << p_v->get_cvec() << endl;
      set_taps(p_v->get_cvec());
      break;

    case SCI_STATE:
      debug(3) << "sci_fir_x::set SCI_STATE cv=" << p_v->get_cvec() << endl;
      set_state(p_v->get_cvec());
      break;

    case SCI_OUTPUT:
      debug(3) << "sci_fir_x::set SCI_OUTPUT  cv=" << p_v->get_complex() << endl;
      set_output(p_v->get_complex());
      break;

    default:
      throw sci_exception("sci_fir_x::set - unknown param");
  }
  return;
}

/*! creates new sci_var and assigns its value to the requested parameter of complex FIR filter
<pre>
Supported parameters:
\a SCI_TYPE,  \a sci_var [int] \n
\a SCI_SIZE,  \a sci_var [int] \n
\a SCI_TAPS,  \a sci_var [cvec] \n
\a SCI_STATE, \a sci_var [cvec] \n
\a SCI_OUTPUT \a sci_var [double] \n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_fir_x::get(int param)
{
  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_FIR_X;
      debug(3) << "sci_fir::get SCI_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_size();
      debug(3) << "sci_fir_x::get SCI_SIZE  iv=" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_TAPS:
    {
      sci_var* p_sci_var_cvec = new sci_var_cvec;
      cvec &cv = (dynamic_cast<sci_var_cvec *>(p_sci_var_cvec))->v;
      cv = get_taps();
      debug(3) << "sci_fir_x::get SCI_TAPS  cv=" << cv << endl;
      return(p_sci_var_cvec);
    }

    case SCI_STATE:
    {
      sci_var* p_sci_var_cvec = new sci_var_cvec;
      cvec &cv = (dynamic_cast<sci_var_cvec *>(p_sci_var_cvec))->v;
      cv = get_input();
      debug(3) << "sci_fir_x::get SCI_STATE  cv=" << cv << endl;
      return(p_sci_var_cvec);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complex<double> &xv = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      xv = y0;
      debug(3) << "sci_fir_x::get SCI_OUTPUT  xv =" << xv << endl;
      return(p_sci_var_complex);
    }

    default:
      throw sci_exception("sci_fir_x::get - unknown param");
  }
};

/*! executes command in na object of a complex FIR filter
<pre>
Supported commands:
\a SCI_RESET \n
</pre>
\param [in] command - to be executed
*/
void sci_fir_x::exec(int command)
{
  switch(command)
  {
    case SCI_RESET:
      reset();
      set_output(std::complex<double>(0.0, 0.0));
      break;

    default:
      throw sci_exception("sci_fir_x::exec - unknown command");
  }
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::fir_x::process() \n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x  - sci_var [vec]
\return             - pointer to y - new  sci_var [cvec]
*/
sci_var* sci_fir_x::proc(sci_var* p_v_ce, sci_var* p_v_x)
{

  sci_var* p_y = new sci_var_cvec;
  cvec &y = (dynamic_cast<sci_var_cvec *>(p_y))->v;

  debug(3) << "sci_fir_x::proc ce= " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_fir_x::proc  x= " << p_v_x->get_cvec() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_cvec());

  debug(3) << "sci_fir_x::proc y= " << y << endl;
  return (p_y);

};


} // namespace SCI