/*xxx
* \brief -  SCI_IQ2AP API
* \author maki
*/

#include "sci\sci_iq2ap.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_iq2ap::sci_iq2ap()
{
  debug(3) << "sci_iq2ap created \n";
};

sci_iq2ap::~sci_iq2ap()
{
  debug(3) << "sci_iq2ap destroyed \n";
};

/*! sets parameters of a IQ2AP \n
<pre>
Supported parameters:
\a SCI_OUTPUT,      \a sci_var [vec]  output for ce=0\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with the value of the parameter
*/
void sci_iq2ap::set(int param, sci_var* p_v)
{

  switch(param)
  {

    case SCI_OUTPUT:
      debug(3) << "sci_iq2ap::set SCI_OUTPUT  v = " << p_v->get_vec() << endl;
      set_output(p_v->get_vec());
      break;

    default:
      throw sci_exception("sci_iq2ap::set - unknown param");
  }
  return;
}

/*! creates new sci_var object and assigns its value to a parameter of the IQ2AP \n
<pre>
Supported parameters:
\a SCI_TYPE,        \a sci_var [int]   \n
\a SCI_OUTPUT,      \a sci_var [vec]  initial output\n
</pre>
\param [in] param   - parameter to get
\return             - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_iq2ap::get(int param)
{
  switch(param)
  {

    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_IQ2AP;
      debug(3) << "sci_iq2ap::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_vec = new sci_var_vec;
      vec &v = (dynamic_cast<sci_var_vec *>(p_sci_var_vec))->v;
      v = get_output();
      debug(3) << "sci_iq2ap::get SCI_OUTPUT v =" << v << endl;
      return(p_sci_var_vec);
    }

    default:
      throw sci_exception("sci_iq2ap::get - unknown param", param);
  }
};

/*! executes command in an object of a IQ2AP
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_iq2ap::exec(int command)
{
  throw sci_exception("sci_iq2ap::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::iq2ap::process()\n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x - sci_var [mat]
\return             - pointer to y - new sci_var [cvec]
*/
sci_var* sci_iq2ap::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_mat;
  mat &y = (dynamic_cast<sci_var_mat *>(p_y))->v;

  debug(3) << "sci_iq2ap::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_iq2ap::proc  x = " << p_v_x->get_cvec() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_cvec());

  debug(3) << "sci_iq2ap::proc  y =" << y << endl;
  return (p_y);

};


} // namespace SCI