/*xxx
* \brief - SCI_LFSR API
* \author maki
*/

#include "sci\sci_lfsr.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_lfsr::sci_lfsr()
{
  debug(3) << "sci_lfsr created \n";
};

sci_lfsr::~sci_lfsr()
{
  debug(3) << "sci_lfsr destroyed \n";
};

/*! set parameters of a LFSR \n
<pre>
Supported parameters:
\a SCI_POLY,        \a sci_var [bvec]\n
\a SCI_STATE,       \a sci_var [bvec]\n
\a SCI_RESET_STATE, \a sci_var [bvec]\n
\a SCI_OUTPUT,      \a sci_var [bvec]\n
\a SCI_SYMBOL_SIZE, \a sci_var [int]\n
\a SCI_PRBS,        \a sci_var [int]\n
\a SCI_REVERSE_FLAG \a sci_var [bool]\n
</pre>
\note SET SCI_POLY or SCI_PRBS and SCI_SYMBOL_SIZE are necessary configuration
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_lfsr::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_POLY:
      debug(3) << "sci_lfsr::set SCI_POLY  bv=" << p_v->get_bvec() << endl;
      set_poly(p_v->get_bvec());
      break;

    case SCI_STATE:
      debug(3) << "sci_lfsr::set SCI_STATE  bv=" << p_v->get_bvec() << endl;
      set_state(p_v->get_bvec());
      break;

    case SCI_RESET_STATE:
      debug(3) << "sci_lfsr::set SCI_RESET_STATE  bv=" << p_v->get_bvec() << endl;
      set_reset_state(p_v->get_bvec());
      break;

    case SCI_OUTPUT:
      debug(3) << "sci_lfsr::set SCI_OUTPUT  bv=" << p_v->get_bvec() << endl;
      set_output(p_v->get_bvec());
      break;

    case SCI_SYMBOL_SIZE:
      debug(3) << "sci_lfsr::set SCI_SYMBOL_SIZE W =" << p_v->get_int() << endl;
      set_symbol_size(p_v->get_int());
      break;

    case SCI_PRBS:
      debug(3) << "sci_lfsr::set SCI_SYMBOL_SIZE M =" << p_v->get_int() << endl;
      set_prbs(p_v->get_int());
      break;

    case SCI_REVERSE_FLAG:
      debug(3) << "sci_lfsr::set SCI_REVERSE_FLAG =" << p_v->get_bool() << endl;
      set_rev_flag(p_v->get_bool());
      break;

    default:
      throw sci_exception("sci_lfsr::set - unknown param");
  }
  return;
};

/*! create new sci_var object and assign its value to LFSR parameter
<pre>
Supported parameters:
\a SCI_TYPE,  \a sci_var [int] \n
\a SCI_SYMBOL_SIZE,  \a sci_var [int] \n
\a SCI_LENGTH,  \a sci_var [int] \n
\a SCI_POLY,  \a sci_var [bvec] \n
\a SCI_STATE, \a sci_var [bvec] \n
\a SCI_RESET_STATE, \a sci_var [bvec] \n
\a SCI_OUTPUT, \a sci_var [bvec] \n
\a SCI_REVERSE_FLAG \a sci_var [bool]\n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_lfsr::get(int param)
{
  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_LFSR;
      debug(3) << "sci_lfsr::get SCI_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_STATE:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &bv = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      bv = get_state();
      debug(3) << "sci_lfsr::get SCI_STATE bv=" << bv << endl;
      return(p_sci_var_bvec);
    }

    case SCI_LENGTH:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_length();
      debug(3) << "sci_lfsr::get SCI_LENGTH iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SYMBOL_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_symbol_size();
      debug(3) << "sci_lfsr::get SCI_SYMBOL_SIZE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_POLY:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &bv = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      bv = get_poly();
      debug(3) << "sci_lfsr::get SCI_POLY bv=" << bv << endl;
      return(p_sci_var_bvec);
    }

    case SCI_RESET_STATE:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &bv = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      bv = get_reset_state();
      debug(3) << "sci_lfsr::get SCI_RESET_STATE  bv=" << bv << endl;
      return(p_sci_var_bvec);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &bv = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      bv = get_output();
      debug(3) << " sci_lfsr::get SCI_OUTPUT  bv=" << bv << endl;
      return(p_sci_var_bvec);
    }

    case SCI_REVERSE_FLAG:
    {
      sci_var* p_sci_var_bool = new sci_var_bool;
      bool &bv = (dynamic_cast<sci_var_bool *>(p_sci_var_bool))->v;
      bv = get_rev_flag();
      debug(3) << " sci_lfsr::get SCI_REVERSE_FLAG  bv=" << bv << endl;
      return(p_sci_var_bool);
    }

    default:
      throw sci_exception("sci_lfsr::get - unknown param");
  }
};

/*! execute command for an instance of a LFSR
<pre>
Supported commands:
\a SCI_RESET \n
</pre>
\param [in] command - to be executed
*/
void sci_lfsr::exec(int command)
{
  switch(command)
  {
    case SCI_RESET:
      set_state(get_reset_state());
      debug(3) << "sci_lfsr::exec(SCI_RESET)" << endl;
      break;

    default:
      throw sci_exception("sci_lfsr::exec - unknown command");
  }
  return;
};

/*! for active [ce] ticks, assign newly created symbol [bvec] to output row
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\return             - pointer to y - new sci_var [bmat]
*/
sci_var* sci_lfsr::gen(sci_var* p_v_ce)
{
  sci_var* p_y = new sci_var_bmat;
  bmat &y = (dynamic_cast<sci_var_bmat *>(p_y))->v;

  debug(3) << "sci_lfsr::gen ce=" << endl << p_v_ce->get_bvec() << endl;

  y = generate(p_v_ce->get_bvec());	
  
  debug(3) << "sci_lfsr::gen y=" << endl << y << endl;
  return (p_y);
};

} // namespace SCI
