/*xxx
* \brief - SCI_LSR API
* \author maki
*/

#include "sci\sci_lsr.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_lsr::sci_lsr()
{
  debug(3) << "sci_lsr created " << endl;
};

sci_lsr::~sci_lsr()
{
  debug(3) << "sci_lsr destroyed " << endl;
};

/*! set parameters of a LSR \n
<pre>
Supported parameters:
\a SCI_LENGTH,  \a sci_var [int]\n
\a SCI_SYMBOL_SIZE, \a sci_var [int]\n
\a SCI_STATE,  \a sci_var [bvec]\n
\a SCI_RESET_STATE, \a sci_var [bvec]\n
\a SCI_OUTPUT, \a sci_var [bvec]\n
</pre>
\note SCI_SIZE <==> SCI_LENGHT
\note SET SCI_SIZE or SCI_LENGHT and SCI_SYMBOL_SIZE are necessary configuration
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/

void sci_lsr::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_LENGTH:
      debug(3) << "sci_lsr::set SCI_LENGTH i=" << p_v->get_int() << endl;
      set_length(p_v->get_int());
      break;

    case SCI_SYMBOL_SIZE:
      debug(3) << "sci_lsr::set SCI_SYMBOL_SIZE i=" << p_v->get_int() << endl;
      set_symbol_size(p_v->get_int());
      break;

    case SCI_STATE:
      debug(3) << "sci_lsr::set SCI_STATE  bv=" << p_v->get_bvec() << endl;
      set_state(p_v->get_bvec());
      break;

    case SCI_RESET_STATE:
      debug(3) << "sci_lsr::set SCI_RESET_STATE bv=" << p_v->get_bvec() << endl;
      set_reset_state(p_v->get_bvec());
      break;

    case SCI_OUTPUT:
      debug(3) << "sci_lsr::set SCI_OUTPUT  bv=" << p_v->get_bvec() << endl;
      set_output(p_v->get_bvec());
      break;

    default:
      throw sci_exception("sci_lsr::set - unknown param");
  }
  return;
};

/*! create new sci_var object and assign its value to LSR parameter \n
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int]\n
\a SCI_LENGTH,  \a sci_var [int]\n
\a SCI_SYMBOL_SIZE, \a sci_var [int]\n
\a SCI_STATE,  \a sci_var [bvec]\n
\a SCI_RESET_STATE, \a sci_var [bvec]\n
\a SCI_OUTPUT, \a sci_var [bvec]\n
</pre>
\note SCI_SIZE <==> SCI_LENGHT
\param [in] param   - parameter to get
*/
sci_var* sci_lsr::get(int param)
{

  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_LSR;
      debug(3) << "sci_lsr::get SCI_TYPE iv =" << p_sci_var_int->get_int() << endl;
      return(p_sci_var_int);
    }

    case SCI_LENGTH:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_length();
      debug(3) << "sci_lsr::get SCI_LENGTH iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_SYMBOL_SIZE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_symbol_size();
      debug(3) << "sci_lsr::get SCI_SYMBOL_SIZE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_STATE:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &bv = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      bv = get_state();
      debug(3) << "sci_lsr::get SCI_STATE  bv=" << bv << endl;
      return(p_sci_var_bvec);
    }

    case SCI_RESET_STATE:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &bv = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      bv = get_reset_state();
      debug(3) << "sci_lsr::get SCI_RESET_STATE  bv=" << bv << endl;
      return(p_sci_var_bvec);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_bvec = new sci_var_bvec;
      bvec &bv = (dynamic_cast<sci_var_bvec *>(p_sci_var_bvec))->v;
      bv = get_output();
      debug(3) << "sci_lsr::get SCI_OUTPUT  bv=" << bv << endl;
      return(p_sci_var_bvec);
    }

    default:
      throw sci_exception("sci_lsr::get - unknown param");
  }
};

/*! execute command for an instance of a LSR
<pre>
Supported commands:
\a SCI_RESET \n
</pre>
\param [in] command - to be executed
*/
void sci_lsr::exec(int command)
{
  bvec bv;
  switch(command)
  {
    case SCI_RESET:
      set_state(get_reset_state());
      debug(3) << "sci_lsr::exec(SCI_RESET)" << endl;
      break;

    default:
      throw sci_exception("sci_lsr::exec - unknown command");
  }
  return;
};

/*! for active [ce] ticks, shift in x[i,:] symbol and shift out y[i,:] symbol
\note symbols x[i,:], y[i,:] are rows in input/output bmat
\note for ce[N] and symbol_size W, input/output matrix have size x[N,W], y[N,W]
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x - sci_var [bmat]
\return             - pointer to y - new sci_var [bmat]
*/
sci_var* sci_lsr::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_bmat;
  bmat &y = (dynamic_cast<sci_var_bmat *>(p_y))->v;

  debug(3) << "sci_lsr::proc ce=" << endl << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_lsr::proc x=" << endl << p_v_x->get_bmat() << endl;
  y = process(p_v_ce->get_bvec(), p_v_x->get_bmat());
  debug(3) << "sci_lsr::proc y=" << endl << y << endl;
  return (p_y);
};

} // namespace SCI
