/*xxx
* \brief SCI_MIX API
* \author maki
*/

#include "sci\sci_mix.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_mix::sci_mix()
{
  debug(3) << "sci_mix created \n";
};

sci_mix::~sci_mix()
{
  debug(3) << "sci_mix destroyed \n";
};

/*!  sets parameter of a mixer \n
<pre>
Supported parameters:
\a SCI_OUTPUT,  \a sci_var [double] output value y0 \n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_mix::set(int param, sci_var* p_v)
{

  switch(param)
  {

    case SCI_OUTPUT:
      debug(3) << "sci_mix::set SCI_OUTPUT  v=" << p_v->get_double() << endl;
      set_output(p_v->get_double());
      break;

    default:
      throw sci_exception("sci_mix::set - unknown param");
  }
  return;
};

/*! creates new sci_var and assigns its value to the requested parameter of a mixer
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int] \n
\a SCI_OUTPUT,  \a sci_var [complex] output value \n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_mix::get(int param)
{

  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_MIX;
      debug(3) << "sci_mix::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      v = get_output();
      debug(3) << "sci_mix::get SCI_OUTPUT v =" << v << endl;
      return(p_sci_var_double);
    }

    default:
      throw sci_exception("sci_mix::get - unknown param");
  }

};

/*! executes command in an object of a mixer \n
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_mix::exec(int command)
{
  throw sci_exception("sci_mix::exec - unknown command");
  return;
};

/*! creates sci_var and assign its value to the output of a mixer [y][vec] 
 by processing input [x][mat] for active [ce][bvec] ticks 
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x  - sci_var [mat]
\return             - pointer to y - created sci_var [vec]
*/
sci_var* sci_mix::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_vec;	
  vec &y = (dynamic_cast<sci_var_vec *>(p_y))->v;

  debug(3) << "sci_mix::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_mix::proc  x = " << p_v_x->get_mat() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_mat());

  debug(3) << "sci_mix::proc  y = " << y << endl;

  return (p_y);
};

} // namespace SCI