/*xxx
* \brief SCI_MIX_X API
* \author maki
*/

#include "sci\sci_mix_x.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_mix_x::sci_mix_x()
{
  debug(3) << "sci_mix_x created \n";
};

sci_mix_x::~sci_mix_x()
{
  debug(3) << "sci_mix_x destroyed \n";
};

/*! sets parameter of a complex mixer \n
<pre>
Supported parameters:
\a SCI_OUTPUT,  \a sci_var [double] output value y0 \n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_mix_x::set(int param, sci_var* p_v)
{

  switch(param)
  {

    case SCI_OUTPUT:
      debug(3) << "sci_mix::set SCI_OUTPUT v=" << p_v->get_complex() << endl;
      set_output(p_v->get_complex());
      break;

    default:
      throw sci_exception("sci_mix_x::set - unknown param");
  }
  return;
}

/*! creates new sci_var and assigns its value to the requested parameter of a complex mixer
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int] \n
\a SCI_OUTPUT,  \a sci_var [complex] output value \n
</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_mix_x::get(int param)
{

  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_MIX_X;
      debug(3) << "sci_mix_x::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_complex = new sci_var_complex;
      complexd &v = (dynamic_cast<sci_var_complex *>(p_sci_var_complex))->v;
      v = get_output();
      debug(3) << "sci_mix_x::get SCI_OUTPUT v =" << v << endl;
      return(p_sci_var_complex);
    }

    default:
      throw sci_exception("sci_mix_x::get - unknown param");
  }
};

/*! executes command in an object of a complex mixer \n
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_mix_x::exec(int command)
{
  throw sci_exception("sci_mix_x::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of a complex mixer [y][cvec] 
    by processing input [x][cmat] for active [ce][bvec] ticks
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x  - sci_var [cmat]
\return             - pointer to y - created sci_var [vec]
*/
sci_var* sci_mix_x::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_cvec;
  cvec &y = (dynamic_cast<sci_var_cvec *>(p_y))->v;

  debug(3) << "sci_mix_x::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_mix_x::proc  x = " << p_v_x->get_cmat() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_cmat());

  debug(3) << "sci_mix_x::proc  y = " << y << endl;

  return (p_y);

};


} // namespace SCI