/*xxx
* \brief SCI_NCO API
* \author maki
*/

#include "sci\sci_nco.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_nco::sci_nco()
{
  debug(3) << "sci_nco created \n";
};

sci_nco::~sci_nco()
{
  debug(3) << "sci_nco destroyed \n";
};

/*! set parameters of a fixed point NCO - numerically controlled oscillator\n
<pre>
Supported parameters:
\a SCI_PARAM_N, \a sci_var [int]  number of bits in fixed point fractional format Q1.N\n
\a SCI_ACC,     \a sci_var [double] phase accumulator state in double fractional format\n
\a SCI_OUTPUT,  \a sci_var [vec] initial output value y0 = [cy|ph]\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with value of the parameter
*/
void sci_nco::set(int param, sci_var* p_v)
{

  switch(param)
  {
    case SCI_PARAM_N:
      debug(3) << " sci_nco::set SCI_PARAM_N  v = " << p_v->get_int() << endl;
      set_N(p_v->get_int());
      break;

    case SCI_ACC:
      debug(3) << "sci_nco::set SCI_ACC  v = " << p_v->get_double() << endl;
      set_acc(p_v->get_double());
      break;

    case SCI_OUTPUT:
      debug(3) << "sci_nco::set SCI_OUTPUT  v=" << p_v->get_vec() << endl;
      set_output(p_v->get_vec());
      break;

    default:
      throw sci_exception("sci_nco::set - unknown param");
  }
  return;
};

/*! create new sci_var object and assign a its value to fixed point NCO parameter
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int] \n
\a SCI_PARAM_N, \a sci_var [int] number of bits in fixed point fractional format Q1.N \n
\a SCI_ACC,     \a sci_var [double] phase accumulator state in double fractional format\n
\a SCI_OUTPUT,  \a sci_var [vec] initial output value y0 = [cy|ph]\n

</pre>
\param [in] param - parameter to get
\return           - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_nco::get(int param)
{

  switch(param)
  {
    case SCI_TYPE:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = SCI_NCO;
      debug(3) << "sci_nco::get SCI_TYPE iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_PARAM_N:
    {
      sci_var* p_sci_var_int = new sci_var_int;
      int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
      iv = get_N();
      debug(3) << "sci_nco::get SCI_PARAM_N iv =" << iv << endl;
      return(p_sci_var_int);
    }

    case SCI_ACC:
    {
      sci_var* p_sci_var_double = new sci_var_double;
      double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
      v = get_acc();
      debug(3) << "sci_nco::get SCI_ACC v =" << v << endl;
      return(p_sci_var_double);
    }

    case SCI_OUTPUT:
    {
      sci_var* p_sci_var_vec = new sci_var_vec;
      vec &v = (dynamic_cast<sci_var_vec *>(p_sci_var_vec))->v;
      v = get_output();
      debug(3) << "sci_nco::get SCI_OUTPUT v =" << v << endl;
      return(p_sci_var_vec);
    }

    default:
      throw sci_exception("sci_ncon::get - unknown param");
  }

};

/*! execute command for an instance of NCO \n
Supported commands:\n
none
\param [in] command - to be executed
*/
void sci_nco::exec(int command)
{
  throw sci_exception("sci_nco::exec - unknown command");
  return;
};

/*! return NCO output [y]=[cy|ph] in newly created sci_var [mat]\n
for active [ce] ticks, fractional phase accumulator sums fractional frequency control words in [x]
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x  - sci_var [vec]
\return             - pointer to y - created sci_var [mat]=[cy|ph]
*/
sci_var* sci_nco::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_mat;	
  mat &y = (dynamic_cast<sci_var_mat *>(p_y))->v;

  debug(3) << " sci_nco::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << " sci_nco::proc  x = " << p_v_x->get_vec() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_vec());

  debug(3) << " sci_nco::proc  y = " << y << endl;
  return (p_y);
};

} // namespace SCI