/*xxx
* \brief -  SCI_PAM_MOD API
* \author maki
*/

#include "sci\sci_pam_mod.hpp"
#include "__debug_level.h"
#include "debug.hpp"

namespace SCI
{

sci_pam_mod::sci_pam_mod()
{
  debug(3) << "sci_pam_mod created \n";
};

sci_pam_mod::~sci_pam_mod()
{
  debug(3) << "sci_pam_mod destroyed \n";
};

/*! sets parameters of a SCI_PAM_MOD \n
<pre>
Supported parameters:
\a SCI_SIZE,      \a sci_var [int] constellation \n
\a SCI_SCALE,     \a sci_var [double] constellation scale, for default scaling determined by size - symbols are in [-1..+1] range \n
\a SCI_OUTPUT,    \a sci_var [double]  output for ce=0\n
</pre>
\param [in] param   - parameter to set
\param [in] p_v     - pointer to sci_var object with the value of the parameter
*/
void sci_pam_mod::set(int param, sci_var* p_v)
{
  switch(param)
  {
    case SCI_SIZE:		// size constellation
      set_size(p_v->get_int());
      break;

    case SCI_SCALE:
      set_scale(p_v->get_double());
      break;

    case SCI_OUTPUT:
      set_output(p_v->get_double());
      break;

    default:
      throw sci_exception("sci_pam_mod::set - unknown param");
  }
  return;
};

/*! creates new sci_var object and assigns its value to a parameter of the SCI_PAM_MOD \n
<pre>
Supported parameters:
\a SCI_TYPE,    \a sci_var [int]  \n
\a SCI_SIZE,    \a sci_var [int]  initial output\n
\a SCI_SCALE,   \a sci_var [double]  initial output\n
\a SCI_OUTPUT,  \a sci_var [complex]  initial output\n
</pre>
\param [in] param   - parameter to get
\return             - pointer to created sci_var, actual object type depends on input parameter
*/
sci_var* sci_pam_mod::get(int param)
{

    switch (param)
    {
      case SCI_TYPE:
      {
        sci_var* p_sci_var_int = new sci_var_int;
        int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
        iv = SCI_PAM_MOD;
        debug(3) << "sci_pam_mod::get SCI_TYPE iv =" << iv << endl;
        return(p_sci_var_int);
      }

      case SCI_SIZE:
      {
        sci_var* p_sci_var_int = new sci_var_int;
        int &iv = (dynamic_cast<sci_var_int *>(p_sci_var_int))->v;
        iv = get_size();
        debug(3) << "sci_pam_mod::get SCI_SIZE iv =" << iv << endl;
        return(p_sci_var_int);
      }

      case SCI_SCALE:
      {
        sci_var* p_sci_var_double = new sci_var_double;
        double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
        v = get_scale();
        debug(3) << "sci_pam_mod::get SCI_SCALE v =" << v << endl;
        return(p_sci_var_double);
      }

      case SCI_OUTPUT:
      {
        sci_var* p_sci_var_double = new sci_var_double;
        double &v = (dynamic_cast<sci_var_double *>(p_sci_var_double))->v;
        v = get_output();
        debug(3) << "sci_pam_mod::get SCI_OUTPUT v =" << v << endl;
        return(p_sci_var_double);
      }
      
      default:
      throw sci_exception("sci_pam_mod::get - unknown param");
    }
};

/*! executes command in SCI_PSK_MOD object
<pre>
Supported commands:
\a none \n
</pre>
\param [in] command - to be executed
*/
void sci_pam_mod::exec(int command)
{
  throw sci_exception("sci_pam_mod::exec - unknown command");
  return;
};

/*! creates sci_var and assigns its value to the output of SIM::psk_mod::process()\n
\param [in] p_v_ce  - pointer to ce - sci_var [bvec]
\param [in] p_v_x   - pointer to x - sci_var [ivec]
\return             - pointer to y - new sci_var [vec]
*/
sci_var* sci_pam_mod::proc(sci_var* p_v_ce, sci_var* p_v_x)
{
  sci_var* p_y = new sci_var_vec;
  vec &y = (dynamic_cast<sci_var_vec *>(p_y))->v;

  debug(3) << "sci_pam_mod::proc ce = " << p_v_ce->get_bvec() << endl;
  debug(3) << "sci_pam_mod::proc  x = " << p_v_x->get_ivec() << endl;

  y = process(p_v_ce->get_bvec(), p_v_x->get_ivec());

  debug(3) << "sci_pam_mod::proc  y = " << y << endl;
  return (p_y);
};

} // namespace SCI
